/**
 * Copyright (c) 2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp11.codemodel

import com.google.inject.Inject
import com.google.inject.Singleton
import com.itemis.create.base.generator.core.codemodel.CompilationUnit
import com.yakindu.base.types.Package
import com.yakindu.sct.generator.cpp11.codepattern.CompilationUnitCode

/**
 * Defines the code model concept of a C++ compilation unit. A compilation unit is a collection of declarations
 * which should be placed in a single C++ source file. A compilation unit model element is a Package which is annotated as 
 * compilation unit. This concept definition provides a builder to create a properly defined element including generator assignment
 * and a query to check if a package element represents a compilation unit. 
 * 
 * @author Axel Terfloth
 */
@Singleton
class Cpp11CompilationUnit extends CompilationUnit {

	@Inject protected extension CompilationUnitCode

	override protected compilationUnitDefinitionGenerator(Package it) {
		compilationUnitImplementationCode
	}
	
	override protected compilationUnitDeclarationGenerator(Package it) {
		compilationUnitHeaderCode
	}

}
