/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp11.codemodel

/**
 * This extension defines the state machine class. 
 * 
 * @author axel terfloth - Initial contribution.
 */

import com.google.inject.Inject
import com.google.inject.Singleton
import com.yakindu.sct.generator.core.codemodel.StatemachineClass
import com.yakindu.sct.generator.cpp.CppFileNaming
import com.yakindu.sct.generator.cpp.CppNaming
import com.yakindu.sct.model.sgraph.Statechart

@Singleton
class Cpp11StatemachineClass extends StatemachineClass{

	
	@Inject protected extension CppNaming cppNaming
	@Inject protected extension CppFileNaming
	
	
	override protected getStatechartNamespace(Statechart it) {
		cppNaming.statechartNamespace(it)
	}
	
	override protected stateMachineClassName(Statechart it) {
		module.asIdentifier.toFirstUpper
	}
	
		
}
