/**
 * Copyright (c) 2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * 	Kovacs Laszlo - itemis AG
 */
package com.yakindu.sct.generator.cpp11.files

import com.google.inject.Inject
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.generator.cpp.CppFileNaming
import com.yakindu.sct.generator.cpp.CppNaming
import com.yakindu.sct.generator.cpp.features.GenmodelEntriesExtension
import com.yakindu.sct.generator.cpp.files.MetaHeader
import com.yakindu.sct.generator.cpp.types.CppTypes
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sgen.GeneratorEntry

class Cpp11MetaHeader extends MetaHeader {
	@Inject extension GenmodelEntriesExtension
	@Inject extension CppNaming
	@Inject extension CppFileNaming
	@Inject extension CppTypes
	@Inject extension SExecExtensions
	
	override content(ExecutionFlow flow, GeneratorEntry entry, extension IGenArtifactConfigurations locations) {
		'''
		«entry.licenseText»

		#ifndef «flow.module.define»_META_H_
		#define «flow.module.define»_META_H_

		#include "«(typesModule.h).relativeTo(flow.metaModule.h)»"
		#include <array>
		
		namespace «flow.module.define»Meta {
		
		constexpr std::size_t «flow.metaFeaturesProperty»Size = «flow.scopes.map[it | it.eventAndVariableDefinitions].flatten.size + 1»;
		extern const std::array<std::«sc_string.name», «flow.metaFeaturesProperty»Size> «flow.metaFeaturesProperty»;
		
		constexpr std::size_t «flow.metaStatesProperty»Size = «flow.states.size +1»;
		extern const std::array<std::«sc_string.name», «flow.metaStatesProperty»Size> «flow.metaStatesProperty»;
		
		} // namespace «flow.module.define»Meta
		

		#endif // «flow.module.define»_META_H_
		'''
	}
	
}