/**
 * Copyright (c) 2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp11.files

import com.yakindu.sct.generator.cpp11.artifacts.HeaderFile

/**
 * Defines the C++11 binding api. 
 * 
 * @author axel terfloth
 */
class SCBinding extends HeaderFile {
	
	public static val BINDING_MODLUE = "sc_binding"
	public static val BINDING_MODLUE_HEADER = BINDING_MODLUE + ".h"
	
	override fileName() {
		BINDING_MODLUE_HEADER
	}
	
	override content() '''
		/* Library for itemis CREATE reactive bindings. */
		
		#ifndef SC_BINDING_H_
		#define SC_BINDING_H_
		
		#include <functional>
		
		namespace sc {
		namespace binding {
		
		class Binder {
		public:
			template<typename Func>
			explicit Binder(Func&& func) : lambda(std::forward<Func>(func)) {}
			
			void update() {
				if (lambda) {
					lambda();
				}
			}
			
		private:
			std::function<void()> lambda;
		};
		
		} /* namespace binding */
		} /* namespace sc */
		
		#endif /* SC_BINDING_H_ */
	'''
	
}