/**
 * Copyright (c) 2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp11.transformation

import com.google.inject.Inject
import com.yakindu.base.base.NamedElement
import com.yakindu.base.expressions.ExpressionBuilder
import com.yakindu.base.expressions.expressions.ArgumentExpression
import com.yakindu.base.expressions.expressions.BlockExpression
import com.yakindu.base.expressions.expressions.ElementReferenceExpression
import com.yakindu.base.expressions.util.ExpressionExtensions
import com.yakindu.sct.generator.core.extensions.EventQueueExtension
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.concepts.EventProcessing
import com.yakindu.sct.model.sexec.concepts.StateMachineBehaviorConcept
import com.yakindu.sct.model.sexec.concepts.SubMachine
import org.eclipse.emf.ecore.util.EcoreUtil

/**
 * As we still depend on the exec flow (mostly due to the flow code) we require to transform it.
 * This class is responsible to update the references to refer the new constructed types throughout expressions, operations, methods...
 * Current state of the trafo is basically copied stuff from the C# 'ExecFlow2stmClassTransformation'.
 * 
 * @author laszlo kovacs
 * 
 */
 //TODO: Should be generalized along with 'ExecFlow2stmClassTransformation'
class Cpp11ExecFlow2StmClassTransformation {
	
	@Inject protected extension EventQueueExtension
	@Inject protected extension StateMachineBehaviorConcept
	@Inject protected extension ExpressionBuilder
	@Inject protected extension ExpressionExtensions
	@Inject protected extension SubMachine
	
	def substitueStateMachineConcepts(ExecutionFlow flow) {
		flow.eAllContents.filter(ElementReferenceExpression).filter [
			reference instanceof NamedElement && (reference as NamedElement).isStateMachineConcept
		].forEach [
			if ((reference as NamedElement).name == EventProcessing.NEXT_EVENT)
				EcoreUtil.replace(it, flow.dispatchEventMethod._ref._with(flow.nextEventMethod._call))
		]
		
		//TODO: Remove this once the the tracing inside Operation bodies are implemented properly
		val traceExprToRemove = newHashSet
		flow.eAllContents.filter(ArgumentExpression).filter[(featureOrReference as NamedElement).name === SubMachine.TRACE_SUBCYCLE_START
			|| (featureOrReference as NamedElement).name === SubMachine.TRACE_SUBCYCLE_END
			].forEach[ traceSubcycleStart |
					traceExprToRemove += traceSubcycleStart
			]
		if(!traceExprToRemove.nullOrEmpty)
			(flow.getRunSubmachineCycle.implementation as BlockExpression).expressions.removeAll(traceExprToRemove)
	}
}