/**
 * Copyright (c) 2021 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp11.types

import com.google.inject.Inject
import com.yakindu.base.types.Type
import com.yakindu.sct.generator.c.types.PlatformTypeMapping
import com.yakindu.sct.generator.core.codemodel.StateEnum

/**
 * @author axel terfloth
 */
class Cpp11PlatformTypeMapping extends PlatformTypeMapping {
	
	@Inject protected extension StateEnum
	
	/**
	 * For C++11 a specific platform type is defined for the state enumeration. 
	 */
	override platformStateEnumeration(Type enumType) {
		return enumType.getOriginStatechart.stateEnum
	}
	
}