/**
 * Copyright (c) 2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.base.model.bindings

import com.google.inject.Inject
import com.yakindu.base.types.Property
import com.yakindu.base.types.TypeBuilder
import com.yakindu.base.types.Operation
import com.yakindu.base.expressions.ExpressionBuilder
import com.google.inject.Singleton

/**
 * This class defines the concept of an out property. Out properties are declared using the @Out annotation
 * and provide a public observable which notifies value changes.
 * 
 * @author axel terfloth
 */
@Singleton
class OutProperty {
	
	public static val OBSERVABLE = "Observable"
	
	@Inject protected extension BindingsTypeLibrary
	@Inject protected extension TypeBuilder
	@Inject protected extension ExpressionBuilder
	@Inject protected extension ReactiveModel
	@Inject protected extension PropertyChangedNotification
	
	def isOutProperty(Property it) {
		it.isOut
	}
	
	def synchronized void defineFeatures(Property it) {
		if (isOutProperty) {
			defineOutPropertyObservable
			defineOutPropertyObservableGetter
		}
	}
	
	def outPropertyObservable(Property p) {
		p.metaFeatures.filter(Property).findFirst[name == p.propertyObservableName]
	}
	
	def protected propertyObservableName(Property it) {
		"_" + it.name + OBSERVABLE
	}
	
	def protected void defineOutPropertyObservable(Property p) {
		if (p.outPropertyObservable === null) {
			p.metaFeatures += _part(p.propertyObservableName) => [
				// TODO: documentation("observable for property ''")
				_protected
				_synthetic
				typeSpecifier = _typeSpecifier(observableType, p.type._typeSpecifier)
			]
			p.addChangeNotifictation(
				"observable"
				, p.outPropertyObservable
					._ref
					._call(observableTypeNext)
					._with(p._ref)
			)
		}
	}
	
	def outPropertyObservableGetter(Property p) {
		p.metaFeatures.filter(Operation).findFirst[name == p.propertyObservableGetterName]
	}
	
	def protected propertyObservableGetterName(Property it) {
		"get" + it.name.toFirstUpper + OBSERVABLE
	}
	
	def protected void defineOutPropertyObservableGetter(Property p) {
		if (p.outPropertyObservableGetter === null) {
			p.metaFeatures += _op(p.propertyObservableGetterName) => [
				_public
				typeSpecifier = _typeSpecifier(observableType, p.type._typeSpecifier)
				implementation = _block( #[ _return(p.outPropertyObservable._ref) ])
			]
		}
	}
	
}