/**
 * Copyright (c) 2026 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.base.model.core

import com.google.inject.Inject
import com.yakindu.base.types.Event
import com.yakindu.base.types.Operation
import com.yakindu.base.types.TypeBuilder
import org.eclipse.xtend.lib.annotations.Accessors
import static com.itemis.create.base.model.core.ConceptModel.*
/**
 * This class defines core features and sematics of events in itemis CREATE. 
 * It defines concepts which are not part of the meta model but are required to define the 
 * execution semantics for events. 
 * 
 * This class makes sure that the event model concepts are accessed in a unified way while 
 * the concrete implementation details are defined by other concepts.
 * 
 * @author axel terfloth - initial contribution
 */
class EventModel {
	
	public static String STORE = "store"
	public static String ACTIVATE = "activate"
	
	@Inject extension TypeBuilder
	 
	/** 
	 * An event may get stored for later usage. The store behavior defines how an event gets stored. 
	 * It may be stored using a queue an event buffer or other mechanisms.
	 * 
	 * The store behavior is optional which means not every event may be stored. So the method may return null.
	 */
	
	@Accessors(PUBLIC_GETTER)
	protected var storeEventConcept = metaConcept(Event, Operation, STORE, [
		_op(STORE, _void)
	])

	/** 
	 * An event can be activated. The activate behavior defines how an event gets activated. 
	 * @return null if behavior is not explicitly defined.
	 */
	@Accessors(PUBLIC_GETTER)
	protected var activateEventConcept = metaConcept(Event, Operation, ACTIVATE, [
		_op(ACTIVATE, _void)
	])
}