/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Andreas Muelder - itemis AG
 * 
 */
package com.yakindu.sctunit.generator.c.extensions

import com.google.inject.Inject
import com.yakindu.sctunit.generator.base.extensions.BaseStatementExtensions
import com.yakindu.sctunit.sCTUnit.AssertionStatement
import com.yakindu.sctunit.sCTUnit.MockReturnStatement
import com.yakindu.sctunit.sCTUnit.VerifyCalledStatement

/**
 * 
 * @author Markus Muehlbrandt - Initial contribution and API
 * @author Jonathan Thoene - Adding of functions to generate mocking statements
 * 
 */
class CStatementExtensions extends BaseStatementExtensions {

	@Inject
	extension CExpressionsExtensions

	@Inject
	extension CMockingExtensions


	def dispatch CharSequence generate(AssertionStatement stm) {
		'''
			EXPECT_TRUE(«stm.expression.code»)«IF !stm.errorMsg.nullOrEmpty» << "«stm.errorMsg»" «ENDIF»;
		'''
	}

	def dispatch CharSequence generate(VerifyCalledStatement it) {
		'''«generateVerifyCalled»'''
	}
	
	def dispatch CharSequence generate(MockReturnStatement it) {
		'''«generateMock»'''
	}
}
