/**
* Copyright (c) 2022 itemis AG - All rights Reserved
* Unauthorized copying of this file, via any medium is strictly prohibited
* 
* Contributors:
* 	Andreas Muelder - itemis AG
*
*/
package com.yakindu.sctunit.generator.c.features

import com.google.inject.Inject
import com.yakindu.sctunit.generator.base.extensions.IGenmodelGenerator
import com.yakindu.sctunit.generator.c.features.CSCTUnitGenmodelEntries
import com.yakindu.sctunit.sCTUnit.SCTUnitClass
import com.yakindu.sct.model.sgen.GeneratorEntry

abstract class BaseGenmodel implements IGenmodelGenerator {
	
	public String generatorType = "null";
	public String testClassName = "null";
	
	@Inject extension CSCTUnitGenmodelEntries
	
	@Inject
	protected GeneratorEntry entry

	def CharSequence generateGenModel(SCTUnitClass it){
		
		// Check for Type
		if(generatorType.equals("c") || generatorType.equals("cpp")){
			generateGenModelCType
		}
		else{
			''''''
		}
	}
	
	def private generateGenModelCType(SCTUnitClass it) {
		
		// Identifier Feature
		var String moduleName = ""
		var String prefix = ""
		var Integer maxLength = null
		var String separator = ""
	
		if(isIdentifierFeature(entry)){
			moduleName = getIdentifierModuleName(entry)
			prefix = getIdentifierStatemachinePrefix(entry)
			maxLength = getIdentifierLength(entry)
			separator = getIdentifierSeparator(entry)
		}
		
		// Function Inlining Feature
		var String inlineReactions = ""
		var String inlineEntryActions = ""
		var String inlineEnterSequences = ""
		var String inlineExitActions = ""
		var String inlineExitSequences = ""
		var String inlineChoices = ""
		var String inlineEntries = ""
		var String inlineEnterRegion = ""
		var String inlineExitRegion = ""
		
		if(isInlineFeature(entry)){
			inlineReactions = getInlineReactions(entry)
			inlineEntryActions = getInlineEntryActions(entry)
			inlineEnterSequences = getInlineEnterSequences(entry) 
			inlineExitActions = getInlineExitActions(entry)
			inlineExitSequences = getInlineExitSequences(entry)
			inlineChoices = getInlineChoices(entry)
			inlineEntries = getInlineEntries(entry)
			inlineEnterRegion = getInlineEnterRegion(entry)
			inlineExitRegion = getInlineExitRegion(entry)
		}
		
		var targetProject = entry.targetFolderString.split("/",2).get(0)
		var targetFolder = ""
		if(entry.targetFolderString.split("/",2).length >= 2)
			targetFolder = entry.targetFolderString.split("/",2).get(1)
		'''
			GeneratorModel for yakindu::«generatorType» {
				statechart «IF !statechart.namespace.nullOrEmpty»«statechart.namespace».«ENDIF»«statechart.name» {
					feature Outlet {
						targetProject = "«targetProject»"
						targetFolder = "«targetFolder»"
					}
					«IF isIdentifierFeature(entry)»	
					feature IdentifierSettings {
						«IF moduleName != ""»moduleName =  "«moduleName»"«ENDIF» 
						«IF prefix != ""»statemachinePrefix =  "«prefix»"«ENDIF» 
						«IF maxLength !== null»maxIdentifierLength = «maxLength»«ENDIF»
						«IF separator != ""»separator =  "«separator»"«ENDIF» 
					}
					«ENDIF»
					«IF isInlineFeature(entry)»	
					feature FunctionInlining {
						«IF inlineReactions != ""      »inlineReactions = «inlineReactions»«ENDIF»
						«IF inlineEntryActions != ""   »inlineEntryActions = «inlineEntryActions»«ENDIF»
						«IF inlineEnterSequences != "" »inlineEnterSequences = «inlineEnterSequences»«ENDIF» 
						«IF inlineExitActions != ""    »inlineExitActions = «inlineExitActions»«ENDIF»
						«IF inlineExitSequences != ""  »inlineExitSequences = «inlineExitSequences»«ENDIF»
						«IF inlineChoices != ""        »inlineChoices = «inlineChoices»«ENDIF»
						«IF inlineEntries != ""        »inlineEntries = «inlineEntries»«ENDIF»
						«IF inlineEnterRegion != ""    »inlineEnterRegion = «inlineEnterRegion»«ENDIF»
						«IF inlineExitRegion != ""     »inlineExitRegion = «inlineExitRegion»«ENDIF»
					}
					«ENDIF»
					feature OutEventAPI {
						getters = «entry.getOutEventGettersUsed»
						observables = «entry.outEventObservablesUsed»
					}
				}
			}
		'''	
		}
	
}
