/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.java

import com.google.inject.Inject
import com.yakindu.sct.generator.core.IExecutionFlowGenerator
import com.yakindu.sct.generator.core.filesystem.ISCTFileSystemAccess
import com.yakindu.sct.generator.java.files.ICycleBased
import com.yakindu.sct.generator.java.files.IEventDriven
import com.yakindu.sct.generator.java.files.IStatemachine
import com.yakindu.sct.generator.java.files.ITimed
import com.yakindu.sct.generator.java.files.ITimerService
import com.yakindu.sct.generator.java.files.ITracingListener
import com.yakindu.sct.generator.java.files.Observable
import com.yakindu.sct.generator.java.files.Observer
import com.yakindu.sct.generator.java.files.RuntimeService
import com.yakindu.sct.generator.java.files.Statemachine
import com.yakindu.sct.generator.java.files.TimerService
import com.yakindu.sct.generator.java.files.TraceEvent
import com.yakindu.sct.generator.java.files.TraceEventType
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.extensions.ShadowEventExtensions
import com.yakindu.sct.model.sexec.naming.INamingService
import com.yakindu.sct.model.sexec.transformation.config.IFlowConfiguration
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.generator.java.files.VirtualTimer

/**
 * This is the Java code generators main class.
 * 
 * @author Markus Mühlbrandt
 * @author Axel Terfloth - extensions
 */
class JavaGenerator implements IExecutionFlowGenerator {

	@Inject extension GenmodelEntries
	@Inject extension GeneratorPredicate
	@Inject extension ShadowEventExtensions

	@Inject extension SExecExtensions
	@Inject extension IStatemachine
	@Inject extension ICycleBased
	@Inject extension IEventDriven
	@Inject extension ITimed
	@Inject extension ITimerService
	@Inject extension TimerService
	@Inject extension VirtualTimer
	@Inject extension ITracingListener
	@Inject extension TraceEvent
	@Inject extension TraceEventType
	@Inject extension RuntimeService
	@Inject extension Statemachine
	@Inject extension Observer
	@Inject extension Observable
	@Inject extension IFlowConfiguration
	
	@Inject INamingService namingService
 	
	override generate(ExecutionFlow flow, GeneratorEntry entry, ISCTFileSystemAccess fsa) {
		
		namingService.initializeNamingService(flow);
		
		flow.generateIStatemachine(entry, fsa)
		if (isCycleBased) {
			flow.generateICycleBased(entry, fsa)
		} else {
			flow.generateIEventDriven(entry, fsa)
		}
		
		if (flow.timed || entry.createTimerService || entry.createVirtualTimerService) {
			flow.generateITimed(entry, fsa)
			flow.generateITimerService(entry, fsa)
			flow.generateVirtualTimerService(entry, fsa)
			if (entry.createTimerService) {
				flow.generateTimerService(entry, fsa);
			} else if(entry.createVirtualTimerService) {
				flow.generateVirtualTimerService(entry, fsa);
			}
		}
		
		if (entry.createRuntimeService) {
			flow.generateRuntimeService(entry, fsa)
		}
		
		flow.generateStatemachine(entry, fsa)
		
		if (entry.tracingUsed) {
			flow.generateTracingListener(entry, fsa)
		}
		
		if (entry.tracingGeneric) {
			flow.generateTraceEvent(entry, fsa)
			flow.generateTraceEventType(entry, fsa)
		}
		
		if ((useOutEventObservables && flow.hasOutgoingEvents) || !flow.shadowEvents.nullOrEmpty || entry.tracingGeneric) {
			flow.generateObservable(entry, fsa)
			flow.generateObserver(entry, fsa)
		}
	}
}