/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.java.files

import com.google.inject.Inject
import com.yakindu.sct.generator.core.extensions.StringHelper
import com.yakindu.sct.generator.core.filesystem.OutputConfigProvider
import com.yakindu.sct.generator.core.library.ICoreLibraryHelper
import com.yakindu.sct.generator.java.GenmodelEntries
import com.yakindu.sct.generator.java.Naming
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sgen.GeneratorEntry
import org.eclipse.xtext.generator.IFileSystemAccess

class TimerService {
	
	@Inject extension Naming 
	@Inject extension GenmodelEntries
	@Inject extension ICoreLibraryHelper
	@Inject extension OutputConfigProvider
	@Inject extension StringHelper
	
	def generateTimerService(ExecutionFlow flow, GeneratorEntry entry, IFileSystemAccess fsa) {
		if (entry.skipLibraryFiles) {
			return
		}
		val fileName = entry.libraryPackage.toPath + '/' + timerServiceClass.java
		fsa.generateFile(fileName, entry.libraryOutputConfig, content(entry))
	}
	
	def private content(GeneratorEntry it) {
		'''
			«licenseText»
			«IF !libraryPackage.isNullOrEmpty»package «libraryPackage»;«ENDIF»
			
			import java.util.ArrayList;
			import java.util.List;
			import java.util.Timer;
			import java.util.TimerTask;
			import java.util.concurrent.locks.Lock;
			import java.util.concurrent.locks.ReentrantLock;
			
			/**
			 * Default timer service implementation.
			 *
			 */
			public class «timerServiceClass» implements «iTimerService» {
				
				private final Timer timer = new Timer();
				
				private final List<TimeEventTask> timerTaskList = new ArrayList<TimeEventTask>();
				
				private final Lock lock = new ReentrantLock();
				
				/**
				 * Timer task that reflects a time event. It's internally used by
				 * {@link «timerServiceClass»}.
				 *
				 */
				private class TimeEventTask extends TimerTask {
				
					private «iTimed» callback;
				
					int eventID;
				
					/**
					 * Constructor for a time event.
					 *
					 * @param callback	an «iTimed» object that is called when the timer expires
					 * @param eventID	the id of the state machine's time event
					 */
					public TimeEventTask(«iTimed» callback, int eventID) {
						this.callback = callback;
						this.eventID = eventID;
					}
				
					public void run() {
						callback.raiseTimeEvent(eventID);
					}
					
					@Override
					public boolean equals(Object obj) {
						if (obj instanceof TimeEventTask) {
							return ((TimeEventTask) obj).callback.equals(callback)
									&& ((TimeEventTask) obj).eventID == eventID;
						}
						return super.equals(obj);
					}
					
					@Override
					public int hashCode() {
						int prime = 37;
						int result = 1;
						
						int c = (int) this.eventID;
						result = prime * result + c;
						c = this.callback.hashCode();
						result = prime * result + c;
						return result;
					}
					
				}
				
				public void setTimer(final «iTimed» callback, final int eventID,
						long time, boolean isPeriodic) {
				
					// Create a new TimerTask for given event and store it.
					TimeEventTask timerTask = new TimeEventTask(callback, eventID);
					lock.lock();
					timerTaskList.add(timerTask);
				
					// start scheduling the timer
					if (isPeriodic) {
						timer.scheduleAtFixedRate(timerTask, time, time);
					} else {
						timer.schedule(timerTask, time);
					}
					lock.unlock();
				}
				
				public void unsetTimer(«iTimed» callback, int eventID) {
					lock.lock();
					int index = timerTaskList.indexOf(new TimeEventTask(callback, eventID));
					if (index != -1) {
						timerTaskList.get(index).cancel();
						timer.purge();
						timerTaskList.remove(index);
					}
					lock.unlock();
				}
				
				/**
				 * Cancel timer service. Use this to end possible timing threads and free
				 * memory resources.
				 */
				public void cancel() {
					lock.lock();
					timer.cancel();
					timer.purge();
					lock.unlock();
				}
			}
		'''
	}
}