/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.java.files

import com.google.inject.Inject
import com.yakindu.sct.generator.java.Naming
import com.yakindu.sct.generator.java.GenmodelEntries
import com.yakindu.sct.generator.core.library.ICoreLibraryHelper
import com.yakindu.sct.generator.core.filesystem.OutputConfigProvider
import com.yakindu.sct.generator.core.extensions.StringHelper
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sgen.GeneratorEntry
import org.eclipse.xtext.generator.IFileSystemAccess

class TraceEventType {
	
	
	@Inject extension Naming
	@Inject extension GenmodelEntries
	@Inject extension ICoreLibraryHelper
	@Inject extension OutputConfigProvider
	@Inject extension StringHelper


	def generateTraceEventType(ExecutionFlow flow, GeneratorEntry entry, IFileSystemAccess fsa) {
		if (entry.skipLibraryFiles) {
			return
		}
		val fileName = entry.libraryPackage.toPath + '/' + traceEventTypeEnum.java
		fsa.generateFile(fileName, entry.libraryOutputConfig, content(entry))
	}
	
	def private content(GeneratorEntry it) {
		'''
			«licenseText»
			«IF !libraryPackage.isNullOrEmpty»package «libraryPackage»;«ENDIF»
			
			/**
			 * Trace event type enumeration. 
			 */
			public enum «traceEventTypeEnum» {
				MACHINE_ENTER,
				MACHINE_EXIT,
				MACHINE_RTS_START,
				MACHINE_RTS_STOP,
				STATE_ENTERED,
				STATE_EXITED,
				STATE_TRANSITION,
				EVENT_RAISED,
				VARIABLE_SET,
				TIME_EVENT_RAISED,
				TIME_EVENT_SET,
				TIME_EVENT_UNSET
			}

			
		'''
	}



}