/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.java.submodules

import com.google.inject.Inject
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.generator.java.Naming

/**
 * 
 * @author Thomas Kutz
 */
class InitializedCheckCode implements com.yakindu.sct.generator.core.submodules.lifecycle.InitializedCheckCode {

	@Inject extension SExecExtensions
	@Inject protected extension Naming

	override initializedCheckCode(ExecutionFlow flow) '''
		«IF flow.timed»
			if («timerServiceInstance» == null) {
				throw new IllegalStateException("Timer service must be set.");
			}
		«ENDIF»
		«FOR internalScope : flow.internalScopes»
			«IF internalScope.hasOperations»
				if (this.«internalScope.operationCallbackInstance» == null) {
					throw new IllegalStateException("Internal operation callback must be set.");	
				}
			«ENDIF»
		«ENDFOR»
		«FOR scope : flow.namedInterfaceScopes»
			«IF scope.hasOperations»
				if (this.«scope.interfaceVariableName».«scope.operationCallbackInstance» == null) {
					throw new IllegalStateException("Operation callback for interface «scope.interfaceTypeName» must be set.");
				}
				
			«ENDIF»
		«ENDFOR»
		«val defaultScope = flow.defaultScope»
		«IF defaultScope !== null && defaultScope.hasOperations»
			if (this.«defaultScope.operationCallbackInstance» == null) {
				throw new IllegalStateException("Operation callback must be set.");
			}
		«ENDIF»
		
	'''

}
