/**
 * Copyright (c) 2020-2024 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.java.submodules

import com.google.inject.Inject
import com.yakindu.sct.generator.core.templates.TraceCodeGenerator
import com.yakindu.sct.generator.java.GenmodelEntries
import com.yakindu.sct.generator.java.JavaExpressionsGenerator
import com.yakindu.sct.generator.java.Naming
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.ExecutionState
import com.yakindu.sct.model.sexec.ScheduleTimeEvent
import com.yakindu.sct.model.sexec.Trace
import com.yakindu.sct.model.sexec.TraceBeginRunCycle
import com.yakindu.sct.model.sexec.TraceEndRunCycle
import com.yakindu.sct.model.sexec.TraceReactionWillFire
import com.yakindu.sct.model.sexec.TraceStateEntered
import com.yakindu.sct.model.sexec.TraceStateExited
import com.yakindu.sct.model.sexec.UnscheduleTimeEvent
import com.yakindu.sct.model.sgraph.RegularState
import com.yakindu.sct.model.stext.stext.EventDefinition
import com.yakindu.sct.model.stext.stext.VariableDefinition

/**
 * @author Thomas Kutz
 * @author axel terfloth
 */
class TraceCode extends TraceCodeGenerator {
	
 	@Inject extension protected GenmodelEntries
 	@Inject extension protected Naming
 	@Inject extension protected JavaExpressionsGenerator
  		

	def dispatch CharSequence traceCode(Trace it) '''
		«callTraceHook»
		«IF (entry.tracingGeneric)»«notifyTrace»«ENDIF»
	'''


	override dispatch CharSequence traceCode(Object it) {
		if (entry.tracingGeneric) notifyTrace else ''''''
	}
	
	def CharSequence traceCode(Object it, Object value) {
		if (entry.tracingGeneric) it.notifyTrace(value) else null
	}

	def CharSequence traceCodeFromNamedScope(Object it, Object value) {
		if (entry.tracingGeneric) it.notifyTraceFromNamedScope(value) else null
	}

	def CharSequence traceTimeEventRaised(ExecutionFlow it, Object tev) {
		if (entry.tracingGeneric) '''
			trace.next(new «traceEventClass»<«flow.statemachineClassName», State, Feature>(TraceEventType.TIME_EVENT_RAISED, this, null, null, «tev»));
		'''
	}
	

	// def protected dispatch notifyTrace(Object it) ''''''
	
	def protected dispatch notifyTrace(VariableDefinition it) 
		'''trace.next(new «traceEventClass»<«flow.statemachineClassName», State, Feature>(TraceEventType.VARIABLE_SET, this, null, Feature.«tracefeatureEnumMemberName», «it.code»));'''
	
	
	def protected dispatch notifyTrace(Object it, Object value) '''// failed attempt to trace ... '''
	
	def protected dispatch notifyTrace(VariableDefinition it, Object value) 
		'''this.trace.next(new «traceEventClass»<«flow.statemachineClassName», State, Feature>(TraceEventType.VARIABLE_SET, this, null, Feature.«tracefeatureEnumMemberName», «value»));'''

	def protected dispatch notifyTrace(EventDefinition it, Object value) 
		'''this.trace.next(new «traceEventClass»<«flow.statemachineClassName», State, Feature>(TraceEventType.EVENT_RAISED, this, null, Feature.«tracefeatureEnumMemberName», «value»));'''


	def protected dispatch notifyTraceFromNamedScope(Object it, Object value) '''// failed attempt to trace ... '''
	
	def protected dispatch notifyTraceFromNamedScope(VariableDefinition it, Object value) 
		'''parent.trace.next(new «traceEventClass»<«flow.statemachineClassName», State, Feature>(TraceEventType.VARIABLE_SET, parent, null, Feature.«tracefeatureEnumMemberName», «value»));'''

	def protected dispatch notifyTraceFromNamedScope(EventDefinition it, Object value) 
		'''parent.trace.next(new «traceEventClass»<«flow.statemachineClassName», State, Feature>(TraceEventType.EVENT_RAISED, parent, null, Feature.«tracefeatureEnumMemberName», «value»));'''


	def protected dispatch notifyTrace(TraceBeginRunCycle it) '''
		trace.next(new «traceEventClass»<«flow.statemachineClassName», State, Feature>(TraceEventType.MACHINE_RTS_START, this));
	'''

	def protected dispatch notifyTrace(TraceEndRunCycle it) '''
		trace.next(new «traceEventClass»<«flow.statemachineClassName», State, Feature>(TraceEventType.MACHINE_RTS_STOP, this));
	'''


	def protected dispatch notifyTrace(TraceStateEntered it) '''
		trace.next(new «traceEventClass»<«flow.statemachineClassName», State, Feature>(TraceEventType.STATE_ENTERED, this, State.«it.state.stateName», null, null));
	'''

	def protected dispatch notifyTrace(TraceStateExited it) '''
		trace.next(new «traceEventClass»<«flow.statemachineClassName», State, Feature>(TraceEventType.STATE_EXITED, this, State.«it.state.stateName», null, null));
	'''

	def protected dispatch notifyTrace(TraceReactionWillFire it) {
		if (reaction.isTransition && reaction.eContainer instanceof ExecutionState) {
			val state = (reaction.eContainer as ExecutionState).sourceElement as RegularState
			val transitionId = state.outgoingTransitions.indexOf(reaction.sourceElement)
			'''
				trace.next(new «traceEventClass»<«flow.statemachineClassName», State, Feature>(TraceEventType.STATE_TRANSITION, this, State.«state.stateName», null, «transitionId»));
			'''		
		}
		else '''// REACTION TRACE'''
	}

	def protected dispatch notifyTrace(ScheduleTimeEvent it) '''
		trace.next(new «traceEventClass»<«flow.statemachineClassName», State, Feature>(TraceEventType.TIME_EVENT_SET, this, null, null, «flow.timeEvents.indexOf(timeEvent)»));	
	'''
	
	def protected dispatch notifyTrace(UnscheduleTimeEvent it) '''
		trace.next(new «traceEventClass»<«flow.statemachineClassName», State, Feature>(TraceEventType.TIME_EVENT_UNSET, this, null, null, «flow.timeEvents.indexOf(timeEvent)»));	
	'''

	


	def protected dispatch callTraceHook(Trace it) '''''' 

	def protected dispatch callTraceHook(TraceStateEntered it) '''
		«IF entry.tracingEnterState»
			for(«tracingListener»<State> «traceSingleInstance» : «traceInstances») {
				«traceSingleInstance».«stateEnteredTraceFunctionID»(State.«it.state.stateName»);
			}
		«ENDIF» 
	'''

	def protected dispatch callTraceHook(TraceStateExited it) '''
		«IF entry.tracingExitState»
			for(«tracingListener»<State> «traceSingleInstance» : «traceInstances») {
				«traceSingleInstance».«stateExitedTraceFunctionID»(State.«it.state.stateName»);
			}
		«ENDIF»
	'''
	
	
	override traceEnterCode(ExecutionFlow it) {
		if (entry.tracingGeneric) '''
			trace.next(new «traceEventClass»<«flow.statemachineClassName», State, Feature>(TraceEventType.MACHINE_ENTER, this));
		'''	
		else ''''''
	}
	
	
	override traceExitCode(ExecutionFlow it) {
		if (entry.tracingGeneric) '''
			trace.next(new «traceEventClass»<«flow.statemachineClassName», State, Feature>(TraceEventType.MACHINE_EXIT, this));
		'''	
		else ''''''
	}
	
	
}
