/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */

package com.yakindu.sct.generator.java.submodules

import com.google.inject.Inject
import com.yakindu.base.types.Event
import com.yakindu.base.types.Property
import com.yakindu.base.types.typesystem.ITypeSystem
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess
import com.yakindu.sct.generator.java.GeneratorPredicate
import com.yakindu.sct.generator.java.JavaExpressionsGenerator
import com.yakindu.sct.generator.java.JavaNamingService
import com.yakindu.sct.generator.java.Naming
import com.yakindu.sct.generator.java.features.OutEventObservables
import com.yakindu.sct.generator.java.features.Synchronized
import com.yakindu.sct.model.sexec.concepts.EventBuffer
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.extensions.ShadowEventExtensions
import com.yakindu.sct.model.sexec.transformation.StatechartExtensions
import com.yakindu.sct.model.sgraph.util.StatechartUtil
import com.yakindu.sct.model.stext.concepts.StatechartAnnotations
import com.yakindu.sct.model.stext.stext.InterfaceScope
import com.yakindu.sct.model.stext.stext.InternalScope
import org.eclipse.emf.ecore.EObject

/**
 * @author BeckmaR
 * @author Thomas Kutz - added out event observers
 */
class VariableCode {
	
	@Inject protected extension Naming
	@Inject protected extension JavaNamingService
	@Inject protected extension ICodegenTypeSystemAccess
	@Inject protected extension SExecExtensions
	@Inject protected extension Synchronized
	@Inject protected extension StatechartUtil
	@Inject protected extension ITypeSystem
	@Inject protected extension StatechartAnnotations
	@Inject protected extension GeneratorPredicate
	@Inject protected extension ShadowEventExtensions
	@Inject protected extension StatechartExtensions
	@Inject protected extension OutEventObservables
	@Inject protected extension EventBuffer
	@Inject protected extension JavaExpressionsGenerator
	@Inject protected extension TraceCode
	
	
	def code(Property it) '''
		«fieldDeclaration»
		
		«IF needsShadowEventMapping»
			«submachineOutEventObservers»
			
		«ENDIF»
		«IF needsGetter»
		«getterCode»
		«ENDIF»
		«IF needsSetter»
		
		«setterCode»
		«ENDIF»
		«IF needsAssignMethod»
		
		«assignCode»
		«ENDIF»
	'''
	
	def fieldDeclaration(Property it) {
		if (isConst)
			constFieldDeclaration
		else
			variableFieldDeclaration
	}
	
	def variableFieldDeclaration(Property it) '''
		private «typeSpecifier.targetLanguageName» «identifier»«IF needsInitialization» = new «typeSpecifier.targetLanguageName»()«ENDIF»;
	'''
	
	def constFieldDeclaration(Property it) '''
		public static final «typeSpecifier.targetLanguageName» «identifier»«IF initialValue !== null» = «initialValue.code»«ENDIF»;
	'''
	
	def getterCode(Property it) '''
		«getterVisibility» «typeSpecifier.targetLanguageName» «getter» {
			«sync(syncObject, '''return «identifier»;''')»
		}
	'''
	
	def setterCode(Property it) '''
		«setterVisibility» void «setter»(«typeSpecifier.targetLanguageName» value) {
			«sync(syncObject, setterContent)»
		}
	'''
	
	def assignCode(Property it) '''
		protected «sync»«typeSpecifier.targetLanguageName» «assign»(«typeSpecifier.targetLanguageName» value) {
			«sync(syncObject, '''
			«setter»(value);
			return «getter»;''')»
		}
	'''
	
	protected def setterContent(Property it) {
		'''
			«IF needsShadowEventMapping»
				if (this.«identifier» != null) {
					«FOR submachineScope : shadowEventsByScope.keySet»
						«FOR shadowEvent : shadowEventsByScope.get(submachineScope)»
							this.«identifier».«IF !submachineScope.name.nullOrEmpty»«submachineScope.interfaceGetterName».«ENDIF»«shadowEvent.getOutEvent.observableGetterName»().unsubscribe(«shadowEvent.observerName»);
						«ENDFOR»
					«ENDFOR»
				}
				
			«ENDIF»
			this.«identifier» = value;
			«setVarTrace»
			«IF needsShadowEventMapping»
				
				if (this.«identifier» != null) {
					«FOR submachineScope : shadowEventsByScope.keySet»
						«FOR shadowEvent : shadowEventsByScope.get(submachineScope)»
							this.«identifier».«IF !submachineScope.name.nullOrEmpty»«submachineScope.interfaceGetterName».«ENDIF»«shadowEvent.getOutEvent.observableGetterName»().subscribe(«shadowEvent.observerName»);
						«ENDFOR»
					«ENDFOR»
				}
			«ENDIF»
		'''
	}
	
	
	protected def setVarTrace(Property it) '''
		«IF scope.isNamedScope»
			«it.traceCodeFromNamedScope('''this.«identifier»''')»
		«ELSE»
			«it.traceCode('''this.«identifier»''')»
		«ENDIF»
	'''
	
	protected def submachineOutEventObservers(Property member) {
		member.shadowEvents.map[submachineOutEventObserver(member)].join
	}
	
	protected def submachineOutEventObserver(Event shadowEvent, Property member) '''
		private «shadowEvent.getOutEvent.observerType» «shadowEvent.observerName» = new «shadowEvent.getOutEvent.observerType»() {
			@Override
			public void next(«shadowEvent.getOutEvent.eventType» value) {
				«member.contextInstance»raise«shadowEvent.name.asName»(«IF shadowEvent.hasValue»value«ENDIF»);
			}
		};
		
	'''
	
	protected def contextInstance(EObject it) {
		if (isInNamedInterface) parentStatemachineInstance + "." else ""
	}

	protected def needsPublicGetter(Property it) {
		switch(eContainer) {
			InternalScope: false
			InterfaceScope: true
			default: false
		}
	}
	
	protected def getterVisibility(Property it) {
		if(needsPublicGetter) '''public «sync»'''.toString.trim else "protected"
	}
	
	protected def needsPublicSetter(Property it) {
		switch(eContainer) {
			InternalScope: false
			InterfaceScope case !readonly: true
			InterfaceScope case readonly: false
			default: false
		}
	}
	
	protected def needsSetter(Property it) {
		!const && !type.isEventBuffer
	}
	
	protected def needsGetter(Property it) {
		!type.isEventBuffer
	}
	
	protected def needsInitialization(Property it) {
		type.isEventBuffer
	}
	
	protected def setterVisibility(Property it) {
		if(needsPublicSetter) '''public''' else "protected"
	}
}