/**
 * Copyright (c) 2020-2024 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.base.expressions.interpreter.context

import com.google.inject.Inject
import com.yakindu.base.base.NamedElement
import com.yakindu.base.expressions.interpreter.base.IInstanceFactory
import com.yakindu.base.types.TypedElement
import com.yakindu.base.types.inferrer.ITypeSystemInferrer
import com.yakindu.sct.model.sruntime.ExecutionSlot
import org.eclipse.xtext.naming.IQualifiedNameProvider

class BuiltInTypeContextInitializer {
	
	@Inject protected extension IQualifiedNameProvider
	@Inject protected extension ITypeSystemInferrer
	@Inject(optional = true) protected extension IInstanceFactory factory
	
	/**
	 * This method is called using PolymorphicDispatcher
	 */
	def createSlotForArray(TypedElement element, IExecutionContextInitializer initializer) {
		if (factory !== null)
			element.infer.newInstance => [
				if (it instanceof ExecutionSlot) {
					name = (element as NamedElement).name
					fqName = element.fullyQualifiedName.toString
				}
			]
		else null
	}
	
	def createSlotForMap(TypedElement element, IExecutionContextInitializer initializer) {
		createSlotForArray(element, initializer)
	}
	
}
