/**
 * Copyright (c) 2026 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.base.expressions.interpreter.types

import com.google.inject.Inject
import com.itemis.create.base.model.core.EventModel
import com.yakindu.base.expressions.interpreter.base.IInterpreter
import com.yakindu.base.expressions.interpreter.base.InterpreterException
import com.yakindu.base.expressions.interpreter.base.ValueSemantics
import com.yakindu.base.types.Event
import com.yakindu.sct.model.sruntime.ExecutionEvent

/**
 * Implements event activation behavior. 
 * 
 * @author axel terfloth
 */
class EventInstance implements IInterpreter.Event {
	
	@Inject protected extension EventModel
	@Inject protected extension ValueSemantics

	protected extension IInterpreter.Context context
	protected ExecutionEvent slot
	protected Event event

	def void setUp(ExecutionEvent eventSlot, Event event, IInterpreter.Context context) {
		this.context = context
		this.event = event
		this.slot = eventSlot
	}
	
	override activate(Object value) {
		val activate = activateEventConcept.definition(event)
		if (activate !== null) {
			val eventOwner = slot.instance
			_try("activate " + event.name, [
				eventOwner.invoke(slot, activate)
			], [ onError |
				throw new InterpreterException(onError)
			])
		} else {
			slot.raised = true
			setValue(slot, value)
		}
	}
}