/**
 * Copyright (c) 2026 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.base.expressions.interpreter.types

import com.yakindu.base.expressions.interpreter.types.RuntimeInstance
import com.yakindu.base.types.Package
import com.yakindu.sct.model.sruntime.CompositeSlot
import com.yakindu.base.expressions.interpreter.base.IInterpreter
import com.yakindu.base.expressions.interpreter.base.IInstanceFactory
import com.yakindu.base.types.typesystem.ITypeSystem
import com.yakindu.base.types.ComplexType
import com.yakindu.base.expressions.expressions.ArgumentExpression
import com.yakindu.base.types.Operation
import com.yakindu.base.types.Expression
import com.yakindu.sct.model.sruntime.ReferenceSlot
import com.yakindu.sct.model.sruntime.SRuntimeFactory
import com.yakindu.sct.model.sruntime.ExecutionSlot

/**
 * Instance behavior implementation for function objects.
 * 
 * @author Axel Terfloth (terfloth@itemis.de)
 */
class FunctionInstance extends RuntimeInstance {
	
	protected extension SRuntimeFactory runtimeFactory = SRuntimeFactory.eINSTANCE
	
	protected Expression behavior
	protected ComplexType functionType
	protected Package declarationPackage
	
	protected ReferenceSlot owner 
	
	def void setUp(CompositeSlot instance, Expression exp, IInterpreter.Context context, IInstanceFactory factory) {
		super.setUp(instance, context, factory)
		this.behavior = exp
		this.functionType = ITypeSystem.FUNCTION.type as ComplexType
		this.declarationPackage = this.functionType.eContainer as Package
		
		owner = createReferenceSlot => [
			name = "owner"
			fqName = name
			instance.slots += it
		]
	}
	
	override declarationPackage() {
		declarationPackage
	}
	
	override declarations() {
		functionType.allFeatures
	}
	
	def void setOwner(ExecutionSlot owner) {
		this.owner.reference = owner
	}
	
	def ExecutionSlot getOwner() {
		return this.owner.reference
	}
	
	override dispatch void doInvoke(ArgumentExpression expr) {
		val feature = expr.featureOrReference

		switch (feature) {
			Operation case "apply" == feature.name:
				apply()
			default:
				super._doInvoke(expr)
		}
	}
	
	def protected apply() {
		_executeOperation(owner.reference, "lambda.apply()", emptyList, [
			behavior._delegate
		])
	}
	
}