/**
 * Copyright (c) 2022-2024 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.base.expressions.interpreter.types

import com.yakindu.base.expressions.interpreter.base.IInstanceFactory
import com.yakindu.base.expressions.interpreter.base.IInterpreter
import com.yakindu.base.types.Package
import com.yakindu.sct.model.sruntime.CompositeSlot

/**
 * At the interpreter level we handle structural members like properties, events and operations 
 * as members of a package interpreter instance. 
 * 
 * @author axel terfloth
 */
class PackageInstance extends RuntimeInstance {

	protected Package declarator

	def void setUp(CompositeSlot instance, Package declarator, IInterpreter.Context context, IInstanceFactory factory) {
		super.setUp(instance, context, factory)		
		this.declarator = declarator 
	}
		
	override declarationPackage() { declarator }
	
	override declarations() { declarator.member }	
			
}
