/**
 * Copyright (c) 2022-2024 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Andreas Muelder - itemis AG
 * 	Axel Terfloth - itemis AG
 * 
 */
package com.yakindu.sctunit.simulation.scxml

import com.google.inject.Inject
import com.yakindu.sct.domain.scxml.simulation.BiDiExecutionContextAdapter
import com.yakindu.sct.model.sruntime.ExecutionEvent
import com.yakindu.sct.simulation.core.coverage.Measurement
import com.yakindu.sct.simulation.core.coverage.MeasurementExtension
import org.apache.commons.scxml2.TriggerEvent
import org.apache.commons.scxml2.model.EnterableState
import org.apache.commons.scxml2.model.Transition
import org.apache.commons.scxml2.model.TransitionTarget
import org.eclipse.debug.core.ILaunch
import org.eclipse.emf.ecore.EObject

/** 
 * 
 * @author andreas muelder - Initial contribution and API
 * 
 */
class SCTUnitBiDiExecutionContextAdapter extends BiDiExecutionContextAdapter {
	
	@Inject(optional = true) ILaunch launch;

	@Inject protected Measurement measurement;
	@Inject protected MeasurementExtension mExtension;


	override synchronized onEntry(EnterableState it) {
		super.onEntry(it)
		if (launch !== null) {
			var foundState = findState(it.id)
			if (foundState !== null) {
				increaseVisited(foundState)
			}
		}
	}

	override synchronized onTransition(TransitionTarget source, TransitionTarget target, Transition transition, String string) {
		super.onTransition(source, target, transition, string)

		if (launch !== null) {
			increaseVisited(findTransition(source, target, string))
		}
	}

	override protected raiseEvent(TriggerEvent it, ExecutionEvent ev) {
		executor.triggerEvent(it)
		ev.raised = false
	}
	
	def increaseVisited(EObject o) {
		if (o === null) return;
		
		try {
			val current = mExtension.forSubject(measurement, o);
			if (current !== null) {
				mExtension.visits(current).increase();
			}
		} catch (Exception e) {
			e.printStackTrace();
		}

	}

	def protected void onVisit(Object subject) {
		if (subject !== null) {
			mExtension.visits(mExtension.forSubject(measurement,subject)).increase
		}
			
	}
}
