/**
 * Copyright (c) 2022-2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.image.library.impl

import com.yakindu.sct.generator.core.library.impl.CoreFeatureTypeLibraryProvider

import static com.yakindu.base.types.typesystem.ITypeSystem.*
import static com.yakindu.sct.generator.image.features.IImageLibraryConstants.*

class ImageFeatureTypeLibraryProvider extends CoreFeatureTypeLibraryProvider {
	
	def renderer() {
		createFeatureType => [
			name = FEATURE_RENDERER
			parameters += createFeatureParameter => [
				name = PARAMETER_FORMAT
				parameterType = getType(STRING)
			]
			parameters += createFeatureParameter => [
				name = PARAMETER_GENERATE_BY_ELEMENT_NAME
				optional = true
				parameterType = getType(STRING)
			]
			parameters += createFeatureParameter => [
				name = PARAMETER_SHORT_NAMING
				optional = true
				parameterType = getType(BOOLEAN)
			]
			parameters += createFeatureParameter => [
				name = PARAMETER_GENERATE_STATE_DOCUMENTATION
				optional = true
				parameterType = getType(BOOLEAN)
			]
		]
	}

	override provide() {
		create([super.provide]) => [
			name = "Image Generator"
			types += renderer()
		]
	}
}
