/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */

package com.yakindu.sctunit.generator.base

import com.google.common.collect.Maps
import com.google.inject.Inject
import com.yakindu.base.expressions.expressions.TimeEventSpec
import com.yakindu.sct.model.sgraph.Statechart
import com.yakindu.sct.model.stext.concepts.StatechartAnnotations
import com.yakindu.sct.model.stext.concepts.SubchartTraversal
import com.yakindu.sct.model.stext.stext.VariableDefinition
import java.util.Map
import com.yakindu.sctunit.generator.base.extensions.BaseNamingExtensions

abstract class AbstractSubchartInitializer extends SubchartTraversal {
	
	@Inject protected extension BaseNamingExtensions
	@Inject protected extension StatechartAnnotations

	public var String initSequence = null
	public var String teardownSequence = null
	public var Map<Statechart, CharSequence> imports = null


	abstract def void buildInitSequence(Statechart subchart, VariableDefinition element);
	
	abstract def void buildTeardownSequence(Statechart subchart, VariableDefinition element);

	def void buildImports(Statechart subchart) {}

	override protected build(Statechart subchart, VariableDefinition element) {
		buildImports(subchart)
		buildInitSequence(subchart, element)
		buildTeardownSequence(subchart, element)
	}
	
	override protected setUp() {
		super.setUp()
		initSequence = ""
		teardownSequence = ""
		imports = Maps.newHashMap
	}
	
	def getSubchartInitSequence(Statechart it) {
		initSequence ?: {
			perform
			initSequence
		}
	}
	
	def getSubchartTeardownSequence(Statechart it) {
		teardownSequence ?: {
			perform
			teardownSequence
		}
	}
	

	def getSubchartImports(Statechart it) {
		imports ?: {
			perform
			imports
		}
	}

	
	def hasTimedSubchart(Statechart it) {
		subchartTypes.exists[isTimed]
	}
	
	def hasCycleBasedSubchart(Statechart it) {
		subchartTypes.exists[isCycleBased]
	}
	
	def needsTimer(Statechart it) {
		isCycleBased || timed || hasCycleBasedSubchart || hasTimedSubchart
	}
	
	def boolean isTimed(Statechart it) {
		eAllContents.filter(TimeEventSpec).size > 0
	}
	
	
}
