/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Jonathan Thoene - itemis AG
 * 
 */
package com.yakindu.sctunit.generator.base.extensions

import com.google.inject.Inject
import com.yakindu.base.expressions.expressions.ElementReferenceExpression
import com.yakindu.base.expressions.expressions.FeatureCall
import com.yakindu.base.types.Expression
import com.yakindu.base.types.Operation
import com.yakindu.base.types.Parameter
import com.yakindu.sct.model.sgraph.Statechart
import com.yakindu.sctunit.sCTUnit.MockReturnStatement
import com.yakindu.sctunit.sCTUnit.MockingStatement
import com.yakindu.sctunit.sCTUnit.SCTUnitClass
import com.yakindu.sctunit.sCTUnit.SCTUnitOperation
import java.util.List
import org.eclipse.emf.ecore.EObject
import org.eclipse.xtext.EcoreUtil2

/**
 * 
 * @author Jonathan Thoene - Initial contribution and API
 * 
 */
class BaseMockingExtensions {
	@Inject protected extension BaseNavigationExtensions
	@Inject protected extension BaseExpressionExtensions
	def isMockingRequired(SCTUnitClass it) {
		!EcoreUtil2.getAllContentsOfType(it, typeof(MockingStatement)).isNullOrEmpty
	}
	
	def dispatch getOperation(ElementReferenceExpression it) {
		reference as Operation
	}

	def dispatch getOperation(FeatureCall it) {
		feature as Operation;
	}

	def dispatch getOperation(Expression it) {
		// Should never be called
	}
	
	def protected dispatch isCustomAnswer(Expression it){
		!eAllContents.filter(ElementReferenceExpression).map[ref|ref == Parameter].isEmpty
	}
	
	def protected dispatch isCustomAnswer(ElementReferenceExpression it){
		reference instanceof Parameter
	}
	
	def getScopesToMock(SCTUnitOperation it) {
		eAllContents.filter(MockingStatement).map[ms|ms.reference.operation.getScope].toSet
	}
	
	def protected getContainerOfType(EObject it, Class<? extends EObject> type) {
		EcoreUtil2.getContainerOfType(it, type)
	}

	def protected getAllOperations(Statechart it) {
		scopes.map[s|s.declarations].flatten.filter(Operation)
	}
	
	def hasCustomAnswers(SCTUnitClass it){
		!SCTUnitOperations.map[tc|tc.body.code].flatten.filter(MockReturnStatement).filter[ms|ms.value.customAnswer].empty
	}
	
	def dispatch List<Expression> argumentExpressions(Expression it){}
	
	def dispatch List<Expression> argumentExpressions(ElementReferenceExpression it){
		return expressions
	}
	
	def dispatch List<Expression> argumentExpressions(FeatureCall it){
		return expressions
	}
}