/**
* Copyright (c) 2022-2025 itemis AG - All rights Reserved
* Unauthorized copying of this file, via any medium is strictly prohibited
* 
* Contributors:
* 	Andreas Muelder - itemis AG
*
*/
package com.yakindu.sctunit.generator.base.extensions

import com.google.inject.Inject
import com.google.inject.Singleton
import com.yakindu.base.expressions.expressions.ElementReferenceExpression
import com.yakindu.base.expressions.expressions.FeatureCall
import com.yakindu.base.expressions.util.ExpressionExtensions
import com.yakindu.sct.model.sgraph.Scope
import com.yakindu.sct.model.sgraph.Statechart
import com.yakindu.sct.model.stext.stext.EventDefinition
import com.yakindu.sct.model.stext.stext.InterfaceScope
import com.yakindu.sct.model.stext.stext.InternalScope
import com.yakindu.sct.model.stext.stext.VariableDefinition
import com.yakindu.sctunit.sCTUnit.MockReturnStatement
import com.yakindu.sctunit.sCTUnit.SCTUnitClass
import com.yakindu.sctunit.sCTUnit.SCTUnitElement
import com.yakindu.sctunit.sCTUnit.SCTUnitOperation
import com.yakindu.sctunit.sCTUnit.SCTUnitSuite
import com.yakindu.sctunit.sCTUnit.TestPackage
import org.eclipse.emf.ecore.EObject
import org.eclipse.xtext.EcoreUtil2

/**
 * 
 * @author oliver bohl - Initial contribution
 * @author axel Terfloth - updates and fixes
 *
 */
@Singleton
class BaseNamingExtensions {
	
	@Inject extension BaseMockingExtensions
	@Inject protected extension BaseNavigationExtensions
	@Inject protected extension ExpressionExtensions
	
	def java(String it) {
		it + ".java"
	}
	
	def namespaceFolder (TestPackage model){
		model.namespace.toString.replaceAll("\\.", "/")
	}
	
	def dispatch CharSequence namespace(TestPackage it) {
		'''«it.name»'''
	}	
	
	def dispatch CharSequence namespace(SCTUnitClass it){
		'''«EcoreUtil2.getContainerOfType(it, typeof(TestPackage)).namespace»'''
	}
	
	def dispatch CharSequence namespace (SCTUnitSuite it){
		'''«EcoreUtil2.getContainerOfType(it, typeof(TestPackage)).namespace»'''
	}
	
	def testClassName(SCTUnitElement it) {
		name.toFirstUpper
	}		
		
	def operationName(SCTUnitOperation it){ 
		name
	}	
	
	def dispatch className(SCTUnitClass it){
		name.toFirstUpper
	}
	
	def dispatch className(SCTUnitSuite it){ 
		name.toFirstUpper
	}	
		
	def dispatch className(Statechart it) {
		name.toFirstUpper
	}
	
	def dispatch valueGetter(EventDefinition definition) {
		'''isRaised'''
	}

	def dispatch valueGetter(VariableDefinition definition) {
		'''get«definition.name.toFirstUpper»'''
	}

	def dispatch valueGetter(EObject object) {
		'''unknown type: «object.eClass.name»'''
	}

	def dispatch CharSequence valueSetter(EventDefinition definition) {
		'''set«definition.name.toFirstUpper»'''
	}

	def dispatch CharSequence valueSetter(ElementReferenceExpression it) {
		reference.valueSetter
	}

	def dispatch CharSequence valueSetter(FeatureCall it) {
		feature.valueSetter
	}

	def dispatch CharSequence valueSetter(VariableDefinition definition) {
		'''set«definition.name.toFirstUpper»'''
	}

	def dispatch valueSetter(EObject object) {
		'''unkonwn type: «object.eClass.name»'''
	}
	
	def dispatch CharSequence mockObjectName(Scope it){/* should never be called */}
	
	def dispatch CharSequence mockObjectName(InterfaceScope it){
		if(!name.nullOrEmpty){
			'''«name.toFirstLower»Mock'''
		}else{
			'''defaultMock'''
		}
	}
	
	def dispatch CharSequence mockObjectName(MockReturnStatement it){
		'''«reference.operation.scope.mockObjectName»'''
	}
	
	def dispatch CharSequence mockObjectName(InternalScope it){
		'''internalMock'''
	}	
}