/**
* Copyright (c) 2022 itemis AG - All rights Reserved
* Unauthorized copying of this file, via any medium is strictly prohibited
* 
* Contributors:
* 	Andreas Muelder - itemis AG
*
*/
package com.yakindu.sctunit.generator.base.extensions

import com.yakindu.sctunit.sCTUnit.SCTUnitClass
import java.util.Calendar
import java.util.Date

/**
 * 
 * @author andreas muelder - Initial contribution and API
 * 
 */
class StaticExtensions {
	
	def imports(){
		'''
		import org.eclipse.xtext.testing.InjectWith;
		import org.eclipse.xtext.testing.XtextRunner;
		import org.junit.Before;
		import org.junit.Test;
		import org.junit.runner.RunWith;
		import com.yakindu.sct.model.sexec.ExecutionFlow;
		import com.yakindu.sct.model.sexec.interpreter.test.util.AbstractExecutionFlowTest;
		import com.yakindu.sct.model.sexec.interpreter.test.util.SExecInjectionProvider;
		import com.yakindu.sct.test.models.SCTUnitTestModels;
		import com.google.inject.Inject;
		import static org.junit.Assert.*;
		'''
	}
	def author(SCTUnitClass sctunitClass){
		'''
		/**
		 * Unit TestCase for «sctunitClass.statechart.name»
		 */
		'''
	}
	
	def year(){
		var cal = Calendar::getInstance();
		cal.setTime(new Date()); 
		return cal.get(Calendar::YEAR); 
	}
	
	
}