/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.examples.wizard;

import com.google.inject.Inject;
import com.yakindu.sct.examples.wizard.pages.SelectExamplePage;
import com.yakindu.sct.examples.wizard.service.ExampleImporter;
import com.yakindu.sct.examples.wizard.service.ExampleModelOpener;
import com.yakindu.sct.examples.wizard.service.ExampleWizardConstants;
import com.yakindu.sct.examples.wizard.service.data.ExampleData;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class ExampleWizard
extends Wizard
implements INewWizard,
ExampleWizardConstants {
    @Inject
    private SelectExamplePage page;
    @Inject
    private ExampleModelOpener opener;
    @Inject
    private ExampleImporter importer;

    public ExampleWizard() {
        this.setWindowTitle("itemis CREATE Examples");
        this.setNeedsProgressMonitor(true);
    }

    public ExampleWizard(String exampleId) {
        this();
        this.page.setInstallExampleId(Collections.singletonList(exampleId));
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        final List<ExampleData> selection = this.page.getSelection();
        if (selection != null) {
            try {
                this.getContainer().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException {
                        for (ExampleData exampleData : selection) {
                            if (!ExampleWizard.this.overrideIfExists(exampleData)) continue;
                            IProject project = ExampleWizard.this.importer.importExample(exampleData, monitor);
                            ExampleWizard.this.opener.openModelFiles(project);
                        }
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    protected boolean overrideIfExists(ExampleData selection) {
        String name = selection.getProjectDir().getName();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        if (project.exists()) {
            OverrideRunnable runnable = new OverrideRunnable(this.getShell(), name);
            Display.getDefault().syncExec((Runnable)runnable);
            if (runnable.isOverride()) {
                try {
                    project.delete(true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            return runnable.isOverride();
        }
        return true;
    }

    private static class OverrideRunnable
    implements Runnable {
        private boolean override = false;
        private Shell shell;
        private String name;

        public OverrideRunnable(Shell shell, String name) {
            this.shell = shell;
            this.name = name;
        }

        @Override
        public void run() {
            this.override = MessageDialog.openQuestion((Shell)this.shell, (String)"Project Exists", (String)String.format("Project %s already exists in your workspace. Do you want to override it?", this.name));
        }

        public boolean isOverride() {
            return this.override;
        }
    }
}

