/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.examples.wizard.drop;

import com.yakindu.sct.examples.wizard.drop.ExampleDropTargetInstaller;
import com.yakindu.sct.examples.wizard.drop.IDropTargetInstaller;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;

public class DropWorkbenchChangeListener
implements IPartListener2,
IPageListener,
IPerspectiveListener,
IWindowListener {
    private IDropTargetInstaller dropTargetInstaller = this.getDropTargetInstaller();

    protected IDropTargetInstaller getDropTargetInstaller() {
        return new ExampleDropTargetInstaller();
    }

    public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        this.pageChanged(page);
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
    }

    public void pageActivated(IWorkbenchPage page) {
        this.pageChanged(page);
    }

    public void pageClosed(IWorkbenchPage page) {
    }

    public void pageOpened(IWorkbenchPage page) {
        this.pageChanged(page);
    }

    protected void pageChanged(IWorkbenchPage page) {
        if (page == null) {
            return;
        }
        IWorkbenchWindow workbenchWindow = page.getWorkbenchWindow();
        this.windowChanged(workbenchWindow);
    }

    public void windowActivated(IWorkbenchWindow window) {
        this.windowChanged(window);
    }

    protected void windowChanged(IWorkbenchWindow window) {
        if (window == null) {
            return;
        }
        Shell shell = window.getShell();
        this.runUpdate(shell);
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowClosed(IWorkbenchWindow window) {
    }

    public void windowOpened(IWorkbenchWindow window) {
        this.hookWindow(window);
    }

    protected void hookWindow(IWorkbenchWindow window) {
        if (window == null) {
            return;
        }
        window.addPageListener((IPageListener)this);
        window.addPerspectiveListener((IPerspectiveListener)this);
        IPartService partService = (IPartService)window.getService(IPartService.class);
        partService.addPartListener((IPartListener2)this);
        this.windowChanged(window);
    }

    public void partOpened(IWorkbenchPartReference partRef) {
        this.partUpdate(partRef);
    }

    public void partActivated(IWorkbenchPartReference partRef) {
        this.partUpdate(partRef);
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
        this.partUpdate(partRef);
    }

    public void partVisible(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
        this.partUpdate(partRef);
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
        this.partUpdate(partRef);
    }

    public void partHidden(IWorkbenchPartReference partRef) {
        this.partUpdate(partRef);
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    protected void partUpdate(IWorkbenchPartReference partRef) {
        if (partRef == null) {
            return;
        }
        IWorkbenchPage page = partRef.getPage();
        this.pageChanged(page);
    }

    protected void runUpdate(final Shell shell) {
        if (shell == null || shell.isDisposed()) {
            return;
        }
        Display display = shell.getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        try {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!shell.isDisposed()) {
                        DropWorkbenchChangeListener.this.dropTargetInstaller.installDropTarget(shell);
                    }
                }
            });
        }
        catch (SWTException ex) {
            if (ex.code == 45) {
                return;
            }
            ex.printStackTrace();
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
        }
    }
}

