/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.examples.wizard.pages;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.yakindu.sct.examples.wizard.service.data.ExampleCategory;
import com.yakindu.sct.examples.wizard.service.data.ExampleData;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ExampleContentProvider
implements ITreeContentProvider {
    private ListMultimap<ExampleCategory, ExampleData> categories = ArrayListMultimap.create();

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.categories.clear();
        if (newInput != null) {
            this.groupCategories((List)newInput);
        }
    }

    protected void groupCategories(List<ExampleData> newInput) {
        for (ExampleData exampleData : newInput) {
            for (ExampleCategory exampleCategory : ExampleCategory.get(exampleData)) {
                this.addExampleToCategory(exampleData, exampleCategory);
            }
        }
    }

    protected void addExampleToCategory(ExampleData exampleData, ExampleCategory category) {
        this.categories.put((Object)category, (Object)exampleData);
    }

    protected int legacyCategoryMapping(String title) {
        switch (title) {
            case "Getting Started - Modeling": {
                return -8;
            }
            case "Getting Started - Code Generation": {
                return -7;
            }
            case "Getting Started - Testing & Coverage": {
                return -6;
            }
            case "Multi State Machines - Code Generation & Modeling": {
                return -5;
            }
            case "Execution Variants": {
                return -4;
            }
            case "Application Examples": {
                return -3;
            }
            case "Embedded Systems": {
                return -2;
            }
            case "Embedded Systems Integration Guide": {
                return -1;
            }
            case "Other": {
                return 1;
            }
        }
        return 0;
    }

    protected int legacyCategorySorting(String title1, String title2) {
        if (this.legacyCategoryMapping(title1) != 0 || this.legacyCategoryMapping(title2) != 0) {
            return this.legacyCategoryMapping(title1) < this.legacyCategoryMapping(title2) ? -1 : 1;
        }
        return title1.compareTo(title2);
    }

    public Object[] getElements(Object inputElement) {
        ArrayList values = Lists.newArrayList();
        values.addAll(this.categories.asMap().keySet());
        values.sort((e1, e2) -> this.legacyCategorySorting(e1.getTitle(), e2.getTitle()));
        return values.toArray();
    }

    public Object[] getChildren(Object parentElement) {
        return this.categories.get((Object)((ExampleCategory)parentElement)).toArray();
    }

    public Object getParent(Object element) {
        if (element instanceof ExampleData && !ExampleCategory.get((ExampleData)element).isEmpty()) {
            return ExampleCategory.get((ExampleData)element).get(0);
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof ExampleCategory;
    }

    public void dispose() {
        this.categories.clear();
    }
}

