/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.examples.wizard.pages;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.yakindu.sct.examples.wizard.pages.ExampleContentProvider;
import com.yakindu.sct.examples.wizard.pages.ExampleLabelProvider;
import com.yakindu.sct.examples.wizard.pages.MessageArea;
import com.yakindu.sct.examples.wizard.service.ExampleWizardConstants;
import com.yakindu.sct.examples.wizard.service.IExampleService;
import com.yakindu.sct.examples.wizard.service.data.ExampleCategory;
import com.yakindu.sct.examples.wizard.service.data.ExampleData;
import com.yakindu.sct.examples.wizard.service.data.IExampleData;
import com.yakindu.sct.ui.install.InstallWizardOpener;
import com.yakindu.sct.ui.install.InstallationChecker;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class SelectExamplePage
extends WizardPage
implements ExampleWizardConstants,
ISelectionChangedListener,
SelectionListener {
    private static final int WIZARD_SIZE_SCALE_FACOTR = 2;
    private static final int WIZARD_SIZE_OFFSET = 300;
    @Inject
    private IExampleService exampleService;
    private TreeViewer viewer;
    private List<ExampleData> selection = Lists.newArrayList();
    private Browser browser;
    private MessageArea messageArea;
    private List<String> exampleIdsToInstall;

    public SelectExamplePage() {
        super("Select an example");
        this.setTitle("Select an example");
        this.setDescription("Choose an example project to import it.");
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.getShell().setBounds(this.calculatePosition(2, 300));
        Composite root = new Composite(parent, 0);
        root.setLayout((Layout)new GridLayout(1, true));
        this.createUpdateGroup(root);
        SashForm container = new SashForm(root, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)container);
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        this.createTreeViewer((Composite)container);
        this.createDetailsPane((Composite)container);
        container.setWeights(new int[]{1, 2});
        this.setControl((Control)container);
        parent.layout();
    }

    private Rectangle calculatePosition(int scale, int offset) {
        Monitor monitor = this.getMonitor();
        int width = (monitor.getBounds().width + (offset *= scale)) / scale;
        int height = (monitor.getBounds().height + offset) / scale;
        int x = monitor.getBounds().x + (width - offset) / scale;
        int y = monitor.getBounds().y + (height - offset) / scale;
        return new Rectangle(x, y, width, height);
    }

    protected Monitor getMonitor() {
        Shell shell = this.getShell();
        Display display = shell.getDisplay();
        Shell displayShell = display.getActiveShell();
        return (displayShell != null ? displayShell : shell).getMonitor();
    }

    private void createUpdateGroup(Composite root) {
        this.messageArea = new MessageArea(root);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.messageArea);
        this.messageArea.addSelectionListener(this);
        this.messageArea.hide();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.initAsync();
        } else {
            this.setPageComplete(false);
            this.selection = Lists.newArrayList();
            this.viewer.setInput(null);
            this.browser.setUrl("about:blank");
        }
    }

    private boolean revealExamplesAutomatically() {
        return this.exampleIdsToInstall != null && !this.exampleIdsToInstall.isEmpty() && (!this.exampleService.exists() || this.exampleService.fetchNewUpdates(null).equals((Object)IExampleService.UpdateResult.NO_UPDATES));
    }

    private void initAsync() {
        try {
            this.getWizard().getContainer().run(true, false, monitor -> this.init(monitor));
        }
        catch (InterruptedException | InvocationTargetException e) {
            e.printStackTrace();
        }
        if (this.revealExamplesAutomatically()) {
            Display.getCurrent().asyncExec(() -> {
                this.messageArea.button.setEnabled(false);
                this.revealExamples();
            });
        }
    }

    private void init(IProgressMonitor monitor) {
        Runnable runnable = () -> {
            this.messageArea.showNoExamplesFound();
            this.explicitLayoutingForUnixSystems();
        };
        if (this.exampleService.exists()) {
            Display.getDefault().syncExec(() -> this.setInput(monitor));
            switch (this.exampleService.fetchNewUpdates(monitor)) {
                case REPO_CONTAINS_CONFLICTS: {
                    runnable = () -> this.messageArea.showRepoContainsConflicts();
                    break;
                }
                case REMOTE_BRANCH_NOT_FOUND: {
                    runnable = () -> this.messageArea.showRemoteBranchNotFound();
                    break;
                }
                case INVALID_CONFIGURATION: {
                    runnable = () -> this.messageArea.showInvalidConfigurationError();
                    break;
                }
                case UPDATE_AVAILABLE: {
                    runnable = () -> this.messageArea.showUpdateAvailable();
                    break;
                }
                case NO_UPDATES: {
                    runnable = () -> {};
                }
            }
        }
        Display.getDefault().syncExec(runnable);
    }

    protected void setInput(IProgressMonitor monitor) {
        List<ExampleData> input = this.exampleService.getExamples((IProgressMonitor)new NullProgressMonitor());
        this.messageArea.hide();
        this.viewer.setInput(input);
        this.explicitLayoutingForUnixSystems();
        this.filterAndSelectExampleToInstall(this.viewer, input);
    }

    private void explicitLayoutingForUnixSystems() {
        this.viewer.getControl().getParent().getParent().layout(true);
    }

    protected void filterAndSelectExampleToInstall(TreeViewer viewer, List<ExampleData> input) {
        final Iterable exampleToInstall = Iterables.filter(input, (Predicate)new Predicate<ExampleData>(){

            public boolean apply(ExampleData input) {
                if (SelectExamplePage.this.exampleIdsToInstall != null) {
                    for (String exampleId : SelectExamplePage.this.exampleIdsToInstall) {
                        if (!exampleId.equals(input.getId())) continue;
                        return true;
                    }
                    return false;
                }
                return true;
            }
        });
        if (exampleToInstall != null) {
            viewer.addFilter(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    if (SelectExamplePage.this.exampleIdsToInstall == null) {
                        return true;
                    }
                    if (SelectExamplePage.this.exampleIdsToInstall.isEmpty()) {
                        return true;
                    }
                    if (element instanceof ExampleData) {
                        for (String exampleId : SelectExamplePage.this.exampleIdsToInstall) {
                            if (!exampleId.equals(((ExampleData)element).getId())) continue;
                            return true;
                        }
                        return false;
                    }
                    if (element instanceof ExampleCategory) {
                        for (ExampleData next : exampleToInstall) {
                            List<ExampleCategory> exampleCategoryList = ExampleCategory.get(next);
                            for (ExampleCategory exampleCategory : exampleCategoryList) {
                                if (!exampleCategory.equals(element)) continue;
                                return true;
                            }
                        }
                        return false;
                    }
                    return true;
                }
            });
            viewer.expandAll();
            viewer.setSelection((ISelection)new StructuredSelection((Object)exampleToInstall), true);
        }
    }

    protected void createTreeViewer(Composite container) {
        this.viewer = new TreeViewer(container, 2818);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.viewer.getControl());
        this.viewer.setContentProvider((IContentProvider)new ExampleContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new ExampleLabelProvider()));
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    protected void updateSelection(List<IExampleData> examples) {
        this.selection.clear();
        for (IExampleData example : examples) {
            if (!(example instanceof ExampleData)) continue;
            this.selection.add((ExampleData)example);
        }
        this.setPageComplete(!this.selection.isEmpty());
        this.setDetailPaneContent(this.selection);
        this.setErrorMessage(null);
        this.viewer.refresh();
        this.checkInstalledPlugins(this.selection);
    }

    private void checkInstalledPlugins(List<ExampleData> data) {
        Display.getCurrent().asyncExec(() -> {
            boolean isMissing = this.isDependenciesMissing(data);
            if (this.messageArea == null || this.getControl() == null) {
                return;
            }
            if (isMissing) {
                this.messageArea.showDependenciesMissing();
            } else {
                this.messageArea.hide();
            }
            this.messageArea.getParent().layout(true);
            this.getControl().update();
        });
    }

    protected boolean isDependenciesMissing(List<ExampleData> examples) {
        InstallationChecker checker = new InstallationChecker();
        HashSet features = Sets.newHashSet();
        for (ExampleData example : examples) {
            ExampleData.Dependency[] dependencies = example.getDependencies();
            if (dependencies == null) continue;
            ExampleData.Dependency[] dependencyArray = dependencies;
            int n = dependencies.length;
            int n2 = 0;
            while (n2 < n) {
                ExampleData.Dependency dependency = dependencyArray[n2];
                features.addAll(Sets.newHashSet((Object[])dependency.getFeatures()));
                ++n2;
            }
        }
        return !checker.isAllFeaturesInstalled((Iterable)features);
    }

    protected void setDetailPaneContent(List<ExampleData> examples) {
        if (examples.size() == 1) {
            String path = examples.get(0).getDescriptionPath();
            if (path != null && new File(path).exists()) {
                this.browser.setUrl(new File(path).toURI().toString());
            } else {
                this.browser.setUrl("about:blank");
            }
        } else {
            this.browser.setUrl("about:blank");
        }
    }

    protected void createDetailsPane(Composite parent) {
        Composite composite = new Composite(parent, 2048);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new FillLayout());
        this.browser = new Browser(composite, 0);
        this.browser.addLocationListener(new LocationListener(){

            public void changing(LocationEvent event) {
                try {
                    String exampleId;
                    String loc = event.location;
                    URI uri = new URI(loc);
                    String scheme = uri.getScheme();
                    if (("https".equals(scheme) || "http".equals(scheme)) && !loc.startsWith("https://www.youtube.com/embed/")) {
                        SelectExamplePage.this.openExternalBrowser(uri.toURL());
                        event.doit = false;
                    } else if ("file".equals(scheme) && (exampleId = this.parseExampleId(uri)) != null) {
                        SelectExamplePage.this.selectExample(exampleId);
                        event.doit = false;
                    }
                }
                catch (MalformedURLException | URISyntaxException e) {
                    e.printStackTrace();
                }
            }

            private String parseExampleId(URI uri) {
                String query = uri.getQuery();
                if (query == null) {
                    return null;
                }
                String[] split = query.split("=");
                if (split.length == 2 && split[0].equals("exampleId")) {
                    return split[1];
                }
                return null;
            }

            public void changed(LocationEvent event) {
            }
        });
    }

    protected void selectExample(String exampleId) {
        List data;
        Optional<ExampleData> example;
        Object input = this.viewer.getInput();
        if (input instanceof List && (example = (data = (List)input).stream().filter(e -> e.getId().equals(exampleId)).findFirst()).isPresent()) {
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)example.get()), true);
        }
    }

    protected void openExternalBrowser(URL url) {
        try {
            PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(url);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    public List<ExampleData> getSelection() {
        return this.selection;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        StructuredSelection structuredSelection = (StructuredSelection)event.getSelection();
        Iterator iter = structuredSelection.iterator();
        ArrayList selectedItems = Lists.newArrayList();
        while (iter.hasNext()) {
            Object next = iter.next();
            if (!(next instanceof IExampleData)) continue;
            selectedItems.add((IExampleData)next);
        }
        this.updateSelection(selectedItems);
    }

    public void widgetSelected(SelectionEvent e) {
        switch (this.messageArea.getState()) {
            case INVALID_CONFIG: {
                this.messageArea.createPreferencePageDialog().open();
                break;
            }
            case DOWNLOAD: 
            case UPDATE: {
                this.revealExamples();
                break;
            }
            case INSTALL: {
                this.installDependencies();
                break;
            }
        }
    }

    protected void installDependencies() {
        if (this.selection != null) {
            List dependencies = this.selection.stream().flatMap(s -> s.getDependencies() != null ? Lists.newArrayList((Object[])s.getDependencies()).stream() : null).collect(Collectors.toList());
            HashMap dependencyMap = Maps.newHashMap();
            for (ExampleData.Dependency dependency : dependencies) {
                dependencyMap.put(dependency.getUpdateSite(), Sets.newHashSet((Object[])dependency.getFeatures()));
            }
            try {
                this.getWizard().getContainer().run(true, true, monitor -> new InstallWizardOpener().open(dependencyMap, monitor));
            }
            catch (InterruptedException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    protected void revealExamples() {
        try {
            this.getWizard().getContainer().run(true, true, monitor -> {
                IStatus status = this.exampleService.fetchAllExamples(monitor);
                Display.getDefault().asyncExec(() -> {
                    if (status.isOK()) {
                        this.setInput(monitor);
                    } else {
                        this.messageArea.showUnableToDownloadError();
                    }
                });
            });
        }
        catch (InterruptedException | InvocationTargetException e1) {
            e1.printStackTrace();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void setInstallExampleId(List<String> exampleId) {
        this.exampleIdsToInstall = exampleId;
    }
}

