/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.examples.wizard.service.data;

import com.yakindu.sct.examples.wizard.service.data.IExampleData;
import java.io.File;
import java.text.Collator;
import java.util.Arrays;

public class ExampleData
implements Comparable<ExampleData>,
IExampleData {
    public static final String DESC_FILE = "index.html";
    private static final String PRO_CATEGORY = "professional";
    private static final String LABS_CATEGORY = "labs";
    private static final String STANDARD_CATEGORY = "standard";
    private static final String PLATFORM_CATEGORY = "platform";
    private static final String HEADLESS_CATEGORY = "headless";
    private String id;
    private String title;
    private String[] category;
    private String description;
    private String[] images;
    private String projectDir;
    private Dependency[] dependencies;
    private int rank = 100;

    public Dependency[] getDependencies() {
        return this.dependencies;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String[] getCategory() {
        return this.category;
    }

    public void setCategory(String[] category) {
        this.category = category;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String[] getImages() {
        return this.images;
    }

    public String[] getFullImagePathes() {
        String[] result = new String[this.images.length];
        String[] imgs = this.getImages();
        int i = 0;
        while (i < imgs.length) {
            result[i] = String.valueOf(this.getProjectDir()) + File.separator + imgs[i];
            ++i;
        }
        return result;
    }

    public void setImages(String[] images) {
        this.images = images;
    }

    public File getProjectDir() {
        return new File(this.projectDir);
    }

    public void setProjectDir(File projectDir) {
        this.projectDir = projectDir.getAbsolutePath();
    }

    public boolean isProfessional() {
        return Arrays.asList(this.getCategory()).contains(PRO_CATEGORY);
    }

    public boolean isLabs() {
        return Arrays.asList(this.getCategory()).contains(LABS_CATEGORY);
    }

    public boolean isStandard() {
        return Arrays.asList(this.getCategory()).contains(STANDARD_CATEGORY);
    }

    public boolean isPlatform() {
        return Arrays.asList(this.getCategory()).contains(PLATFORM_CATEGORY);
    }

    public boolean isHeadless() {
        return Arrays.asList(this.getCategory()).contains(HEADLESS_CATEGORY);
    }

    @Override
    public String getDescriptionPath() {
        return this.getProjectDir().getAbsolutePath() + File.separator + DESC_FILE;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.category == null ? 0 : this.category.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + Arrays.hashCode(this.images);
        result = 31 * result + (this.projectDir == null ? 0 : this.projectDir.hashCode());
        result = 31 * result + (this.title == null ? 0 : this.title.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExampleData other = (ExampleData)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.category == null ? other.category != null : !this.category.equals(other.category)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (!Arrays.equals(this.images, other.images)) {
            return false;
        }
        if (this.projectDir == null ? other.projectDir != null : !this.projectDir.equals(other.projectDir)) {
            return false;
        }
        return !(this.title == null ? other.title != null : !this.title.equals(other.title));
    }

    @Override
    public int compareTo(ExampleData other) {
        int byRank = this.rank - other.rank;
        if (byRank == 0) {
            return Collator.getInstance().compare(this.title, other.title);
        }
        return byRank;
    }

    public static class Dependency {
        private String updateSite;
        private String[] features;

        public Dependency(String updateSite, String[] features) {
            this.updateSite = updateSite;
            this.features = features;
        }

        public String getUpdateSite() {
            return this.updateSite;
        }

        public String[] getFeatures() {
            return this.features;
        }
    }
}

