/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.examples.wizard.service.git;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jgit.lib.ProgressMonitor;

public class EclipseGitProgressTransformer
implements ProgressMonitor {
    private final IProgressMonitor root;
    private SubMonitor mainTask;
    private SubMonitor subTask;
    private String msg;
    private int lastWorked;
    private int totalWork;

    public EclipseGitProgressTransformer(IProgressMonitor eclipseMonitor) {
        this.root = eclipseMonitor;
    }

    public void start(int totalTasks) {
        this.mainTask = SubMonitor.convert((IProgressMonitor)this.root, (int)5);
    }

    public void beginTask(String name, int total) {
        this.msg = name;
        this.lastWorked = 0;
        this.totalWork = total;
        SubMonitor sub = this.mainTask != null ? this.mainTask.newChild(1) : SubMonitor.convert((IProgressMonitor)this.root);
        this.subTask = this.totalWork == 0 ? SubMonitor.convert((IProgressMonitor)sub, (int)-1) : SubMonitor.convert((IProgressMonitor)sub, (int)this.totalWork);
        this.subTask.subTask(this.msg);
    }

    public void update(int work) {
        if (this.subTask == null) {
            return;
        }
        int cmp = this.lastWorked + work;
        if (this.totalWork == 0 && cmp > 0) {
            if (this.lastWorked != cmp) {
                this.subTask.subTask(this.msg + ", " + cmp);
            }
        } else if (this.totalWork > 0 && cmp * 100 / this.totalWork != this.lastWorked * 100 / this.totalWork) {
            StringBuilder m = new StringBuilder();
            m.append(this.msg);
            m.append(": ");
            while (m.length() < 25) {
                m.append(' ');
            }
            String twstr = String.valueOf(this.totalWork);
            Object cmpstr = String.valueOf(cmp);
            while (((String)cmpstr).length() < twstr.length()) {
                cmpstr = " " + (String)cmpstr;
            }
            int pcnt = cmp * 100 / this.totalWork;
            if (pcnt < 100) {
                m.append(' ');
            }
            if (pcnt < 10) {
                m.append(' ');
            }
            m.append(pcnt);
            m.append("% (");
            m.append((String)cmpstr);
            m.append("/");
            m.append(twstr);
            m.append(")");
            this.subTask.subTask(m.toString());
        }
        this.lastWorked = cmp;
        this.subTask.worked(work);
    }

    public void endTask() {
        if (this.subTask != null) {
            try {
                this.subTask.done();
            }
            finally {
                this.subTask = null;
            }
        }
    }

    public boolean isCancelled() {
        if (this.subTask != null) {
            return this.subTask.isCanceled();
        }
        return this.root.isCanceled();
    }

    public void showDuration(boolean enabled) {
    }
}

