/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.yet.sct.debugger.interpreter;

import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import com.yakindu.base.expressions.interpreter.base.IInterpreter;
import com.yakindu.base.expressions.interpreter.base.ResolvingRuntimeInstance;
import com.yakindu.base.expressions.interpreter.base.ValueSemantics;
import com.yakindu.sct.model.sgraph.RegularState;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.sgraph.Vertex;
import com.yakindu.sct.model.sruntime.CompositeSlot;
import com.yakindu.sct.model.sruntime.ExecutionContext;
import com.yakindu.sct.model.sruntime.ExecutionEvent;
import com.yakindu.sct.model.sruntime.ExecutionVariable;
import com.yakindu.yet.core.YETEvent;
import com.yakindu.yet.core.YETScope;
import com.yakindu.yet.core.protocol.IYETMessageSender;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class YETStatechartInstance
extends ResolvingRuntimeInstance {
    protected Statechart statechart;
    @Inject
    protected IQualifiedNameProvider fqnProvider;
    @Inject(optional=true)
    protected IYETMessageSender sender;
    @Inject
    @Extension
    protected ValueSemantics _valueSemantics;
    protected YETScope traceScope = new YETScope(){

        public void executed(YETEvent<?> event) {
            YETStatechartInstance.this.accept(event);
        }
    };
    public static final char META_SEPARATOR = '@';

    public void setUp(CompositeSlot instance, IInterpreter.Context context, Statechart statechart) {
        super.setUp(instance, context);
        this.statechart = statechart;
    }

    public void invoke(Object slot, Object operation) {
        throw new UnsupportedOperationException("TODO: auto-generated method stub");
    }

    protected void _set(ExecutionVariable slot, Object value) {
        long _currentTime = this.context.currentTime();
        String _fqName = slot.getFqName();
        Optional<Object> _xifexpression = null;
        _xifexpression = value != null ? Optional.of(value.toString()) : Optional.empty();
        YETEvent.YETUpdateEvent event = new YETEvent.YETUpdateEvent(_currentTime, _fqName, _xifexpression);
        this.traceScope.stimulated((YETEvent)event);
        if (this.sender != null) {
            this.sender.send((YETEvent)event);
        }
    }

    protected void _set(Object slot, Object value) {
    }

    public void raise(Object slot, Object value) {
        if (slot instanceof ExecutionEvent) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("raise ");
            String _name = ((ExecutionEvent)slot).getName();
            _builder.append(_name);
            Runnable _function = () -> {
                long _currentTime = this.context.currentTime();
                String _fqName = ((ExecutionEvent)slot).getFqName();
                Optional<Object> _xifexpression = null;
                _xifexpression = value != null ? Optional.of(value.toString()) : Optional.empty();
                YETEvent.YETUpdateEvent event = new YETEvent.YETUpdateEvent(_currentTime, _fqName, _xifexpression);
                this.traceScope.stimulated((YETEvent)event);
                if (this.sender != null) {
                    this.sender.send((YETEvent)event);
                }
            };
            this.context._execute(_builder.toString(), _function);
        }
    }

    public void provideExecution(Object program) {
    }

    protected void _accept(YETEvent.YETInitEvent message) {
        block9: {
            String value;
            String key;
            block8: {
                key = this.withoutScope(message.getKey());
                value = (String)message.getValue();
                boolean _isMetaFeature = this.isMetaFeature(key);
                if (!_isMetaFeature) break block8;
                String _feature = this.getFeature(key);
                if (_feature == null) break block9;
                switch (_feature) {
                    case "Enter": {
                        this.onExecutionStart();
                    }
                }
                break block9;
            }
            boolean _isRegularFeature = this.isRegularFeature(key);
            if (_isRegularFeature) {
                this.onValueChanged(0L, key, value);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void _accept(YETEvent.YETUpdateEvent message) {
        long timestamp;
        Optional value;
        String key;
        block21: {
            key = this.withoutScope(message.getKey());
            value = (Optional)message.getValue();
            timestamp = message.getTimestamp();
            boolean _isMetaFeature = this.isMetaFeature(key);
            if (!_isMetaFeature) break block21;
            String _feature = this.getFeature(key);
            if (_feature == null) return;
            switch (_feature) {
                case "RunCycleStart": {
                    this.onRunCycleStarted(timestamp);
                    return;
                }
                case "RunCycleEnd": {
                    this.onRunCycleEnded(timestamp);
                    return;
                }
                case "tev": {
                    this.handleTimeEvent(timestamp, key);
                    return;
                }
                case "StateEntered": {
                    boolean _isPresent = value.isPresent();
                    if (!_isPresent) return;
                    this.onStateEntered(timestamp, (String)value.get());
                    return;
                }
                case "StateExited": {
                    boolean _isPresent_1 = value.isPresent();
                    if (!_isPresent_1) return;
                    this.onStateExited(timestamp, (String)value.get());
                }
                default: {
                    return;
                }
            }
        }
        boolean _isRegularFeature = this.isRegularFeature(key);
        if (!_isRegularFeature) return;
        Object eventOrVariable = this.resolveYETFeature(key);
        if (eventOrVariable instanceof ExecutionVariable && value.isPresent()) {
            this.onValueChanged(timestamp, this.getFeature(key), (String)value.get());
            return;
        } else {
            if (!(eventOrVariable instanceof ExecutionEvent)) return;
            this.onEvent(timestamp, key, value);
        }
    }

    protected Object resolveYETFeature(String key) {
        Functions.Function1 _function = it -> {
            boolean _isEmpty = it.isEmpty();
            return !_isEmpty;
        };
        Functions.Function2 _function_1 = (slot, f) -> this.resolveSlot(slot, f);
        return IterableExtensions.fold((Iterable)IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)key.split("\\."))), (Functions.Function1)_function), (Object)this.instanceSlot, (Functions.Function2)_function_1);
    }

    protected String withoutScope(String it) {
        boolean _not;
        String fqScopeName = this.traceScope.fullyQualifiedName();
        String key = it;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)fqScopeName);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            boolean _startsWith_1;
            boolean _startsWith = it.startsWith(fqScopeName);
            if (_startsWith) {
                key = it.substring(fqScopeName.length());
            }
            if (_startsWith_1 = key.startsWith(".")) {
                key = key.substring(1);
            }
        }
        return key;
    }

    protected boolean isMetaFeature(String key) {
        char _charAt = key.charAt(0);
        return _charAt == '@';
    }

    protected boolean isRegularFeature(String key) {
        boolean _isMetaFeature = this.isMetaFeature(key);
        return !_isMetaFeature;
    }

    protected String getFeature(String s) {
        boolean _isMetaFeature = this.isMetaFeature(s);
        if (_isMetaFeature) {
            return s.substring(1);
        }
        return s;
    }

    public void onExecutionStart() {
    }

    public void onExecutionEnd(long timestamp) {
    }

    public void onEvent(long timestamp, String name, Optional<String> value) {
        Object slot = this.resolveYETFeature(name);
        if (slot instanceof ExecutionEvent) {
            Optional<Object> parsed = this.parseString(value, ((ExecutionEvent)slot).getValue());
            this.internalOnEvent((ExecutionEvent)slot, parsed);
        }
    }

    protected void internalOnEvent(ExecutionEvent event, Optional<Object> value) {
        event.setRaised(true);
        boolean _isPresent = value.isPresent();
        if (_isPresent) {
            event.setValue(value.get());
        }
    }

    public void onStateEntered(long timestamp, String name) {
        Vertex state = this.findState(name);
        if (state != null) {
            this.internalOnStateEntered(state);
        }
    }

    protected void internalOnStateEntered(Vertex state) {
        this.executionContextSlot().getActiveStates().add(state);
    }

    public void onStateExited(long timestamp, String name) {
        Vertex state = this.findState(name);
        if (state != null) {
            this.internalOnStateExited(state);
        }
    }

    protected void internalOnStateExited(Vertex state) {
        this.executionContextSlot().getActiveStates().remove(state);
    }

    public void onRunCycleStarted(long timestamp) {
    }

    public void onRunCycleEnded(long timestamp) {
    }

    public void onValueChanged(long timestamp, String name, String newValue) {
        Object slot = this.resolveYETFeature(name);
        if (slot instanceof ExecutionVariable) {
            Object value = this.parseString(newValue, ((ExecutionVariable)slot).getValue());
            this.internalOnValueChanged((ExecutionVariable)slot, value);
        }
    }

    protected void internalOnValueChanged(ExecutionVariable it, Object value) {
        it.setValue(value);
    }

    public Vertex findState(String name) {
        Functions.Function1 _function = it -> {
            String _string = this.fqnProvider.getFullyQualifiedName((EObject)it).skipFirst(1).toString();
            return Objects.equals(_string, name);
        };
        return (Vertex)IteratorExtensions.head((Iterator)IteratorExtensions.filter((Iterator)Iterators.filter((Iterator)this.statechart.eAllContents(), RegularState.class), (Functions.Function1)_function));
    }

    protected void handleTimeEvent(long timestamp, String key) {
        block13: {
            String feature = this.getFeature(key);
            String[] parts = feature.split("\\.");
            int eventId = Integer.valueOf(parts[1]);
            String event = parts[2];
            if (event == null) break block13;
            switch (event) {
                case "Set": {
                    this.onSetTimeEvent(timestamp, eventId);
                    break;
                }
                case "Unset": {
                    this.onUnsetTimeEvent(timestamp, eventId);
                    break;
                }
                case "Expire": {
                    this.onTimeEvent(timestamp, eventId);
                }
            }
        }
    }

    public Object parseString(String value, Object targetType) {
        if (targetType instanceof String) {
            return value;
        }
        if (targetType instanceof Long) {
            return Long.valueOf(value);
        }
        if (targetType instanceof Integer) {
            return Integer.valueOf(value);
        }
        if (targetType instanceof Boolean) {
            return value.equals("t");
        }
        if (targetType instanceof Float) {
            return Float.valueOf(value);
        }
        if (targetType instanceof Double) {
            return Double.valueOf(value);
        }
        if (targetType instanceof Character) {
            return Character.valueOf(value.charAt(0));
        }
        return value;
    }

    public Optional<Object> parseString(Optional<String> value, Object targetType) {
        boolean _isPresent = value.isPresent();
        if (_isPresent) {
            return Optional.of(this.parseString(value.get(), targetType));
        }
        return Optional.empty();
    }

    public void onClearInEvents(long timestamp) {
        this.internalOnClearInEvents();
    }

    protected void internalOnClearInEvents() {
    }

    public void onClearOutEvents(long timestamp) {
        this.internalOnClearOutEvents();
    }

    protected void internalOnClearOutEvents() {
    }

    public void onSetTimeEvent(long timestamp, int id) {
    }

    public void onUnsetTimeEvent(long timestamp, int id) {
    }

    public void onTimeEvent(long timestamp, int id) {
        Object _resolve = this.resolve(this.instanceSlot, this.timeEventName(id));
        ExecutionEvent timeEvent = (ExecutionEvent)_resolve;
        this.internalOnTimeEvent(timeEvent);
    }

    protected String timeEventName(int id) {
        return String.valueOf((Object)id);
    }

    protected void internalOnTimeEvent(ExecutionEvent findTimeEvent) {
        findTimeEvent.setRaised(true);
    }

    protected ExecutionContext executionContextSlot() {
        return (ExecutionContext)this.instanceSlot;
    }

    @XbaseGenerated
    public void set(Object slot, Object value) {
        if (slot instanceof ExecutionVariable) {
            this._set((ExecutionVariable)slot, value);
            return;
        }
        if (slot != null) {
            this._set(slot, value);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(slot, value).toString());
    }

    @XbaseGenerated
    public void accept(YETEvent<?> message) {
        if (message instanceof YETEvent.YETInitEvent) {
            this._accept((YETEvent.YETInitEvent)message);
            return;
        }
        if (message instanceof YETEvent.YETUpdateEvent) {
            this._accept((YETEvent.YETUpdateEvent)message);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(message).toString());
    }
}

