/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.yet.sct.debugger.launch;

import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.name.Names;
import com.yakindu.sct.commons.PathHelper;
import com.yakindu.yet.core.config.IYETConfigParameters;
import com.yakindu.yet.core.protocol.IYETMessageSender;
import com.yakindu.yet.core.protocol.YETAbstractMessagePort;
import com.yakindu.yet.core.protocol.YETFilePort;
import com.yakindu.yet.core.protocol.YETTCPPort;
import com.yakindu.yet.core.protocol.YETUDPPort;
import java.lang.annotation.Annotation;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.emf.common.util.URI;

public class LaunchConfigurationModule
implements Module,
IYETConfigParameters {
    protected ILaunchConfiguration config;
    protected String projectName;
    protected static Map<Integer, YETUDPPort> UDP_PORT_MAP;
    protected static Map<Integer, YETTCPPort> TCP_PORT_MAP;

    public void configure(Binder binder) {
        String provider = this.getProvider();
        if (this.useFileProvider(provider)) {
            this.bindFileProvider(binder);
        }
        if (this.useUDPProvider(provider)) {
            this.bindUDPProvider(binder);
        }
        if (this.useTCPProvider(provider)) {
            this.bindTCPProvider(binder);
        }
        this.bindInstanceName(binder);
    }

    public LaunchConfigurationModule(ILaunchConfiguration config, String projectName) {
        this.config = config;
        this.projectName = projectName;
    }

    protected void bindFileProvider(Binder binder) {
        binder.bind(YETAbstractMessagePort.class).to(YETFilePort.class);
        binder.bind(String.class).annotatedWith((Annotation)Names.named((String)"YET_PROVIDER_FILE_PATH")).toInstance((Object)this.getFilePathAsString());
        binder.bind(Path.class).annotatedWith((Annotation)Names.named((String)"YET_PROVIDER_FILE_PATH")).toInstance((Object)this.getFilePath());
        binder.bind(Boolean.class).annotatedWith((Annotation)Names.named((String)"IS_TIME_SLAVE")).toInstance((Object)Boolean.FALSE);
    }

    protected void bindUDPProvider(Binder binder) {
        binder.bind(YETAbstractMessagePort.class).to(YETUDPPort.class);
        binder.bind(IYETMessageSender.class).to(YETUDPPort.class);
        binder.bind(YETUDPPort.class).in(Singleton.class);
        binder.bind(String.class).annotatedWith((Annotation)Names.named((String)"YET_PROVIDER_UDP_ADDRESS")).toInstance((Object)this.getUDPAddress());
        binder.bind(Integer.class).annotatedWith((Annotation)Names.named((String)"YET_PROVIDER_UDP_PORT")).toInstance((Object)this.getUDPPort());
        binder.bind(Boolean.class).annotatedWith((Annotation)Names.named((String)"IS_TIME_SLAVE")).toInstance((Object)Boolean.TRUE);
    }

    protected void bindTCPProvider(Binder binder) {
        binder.bind(YETAbstractMessagePort.class).to(YETTCPPort.class);
        binder.bind(IYETMessageSender.class).to(YETTCPPort.class);
        binder.bind(YETTCPPort.class).in(Singleton.class);
        binder.bind(Integer.class).annotatedWith((Annotation)Names.named((String)"YET_PROVIDER_TCP_PORT")).toInstance((Object)this.getTCPPort());
        binder.bind(Boolean.class).annotatedWith((Annotation)Names.named((String)"IS_TIME_SLAVE")).toInstance((Object)Boolean.TRUE);
    }

    protected void bindInstanceName(Binder binder) {
        String instanceName = this.getAttribute("LaunchInstance", "");
        binder.bind(String.class).annotatedWith((Annotation)Names.named((String)"LaunchInstance")).toInstance((Object)instanceName);
    }

    protected String getProvider() {
        return this.getAttribute("YET_PROVIDER", "YET_PROVIDER_UDP");
    }

    protected String getUDPAddress() {
        return this.getAttribute("YET_PROVIDER_UDP_ADDRESS", "");
    }

    protected Integer getUDPPort() {
        String port = this.getAttribute("YET_PROVIDER_UDP_PORT", "4444");
        return Integer.valueOf(port);
    }

    protected Integer getTCPPort() {
        String port = this.getAttribute("YET_PROVIDER_TCP_PORT", "8444");
        return Integer.valueOf(port);
    }

    protected String getFilePathAsString() {
        return this.getAttribute("YET_PROVIDER_FILE_PATH", this.projectName + "/trace.yet");
    }

    protected Path getFilePath() {
        String filePath = this.getFilePathAsString();
        PathHelper helper = new PathHelper();
        URI uri = URI.createPlatformResourceURI((String)filePath, (boolean)false);
        IFile iFile = this.getIFile(uri);
        if (iFile == null) {
            throw new IllegalArgumentException("Could not read trace file: " + filePath);
        }
        return helper.toPath((IResource)iFile, new LinkOption[0]);
    }

    protected IFile getIFile(URI uri) {
        String platformString = uri.toPlatformString(true);
        return (IFile)ResourcesPlugin.getWorkspace().getRoot().findMember(platformString);
    }

    protected String getAttribute(String name, String defaultValue) {
        try {
            return this.config.getAttribute(name, defaultValue);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    protected boolean useFileProvider(String provider) {
        return "YET_PROVIDER_FILE".equals(provider);
    }

    protected boolean useUDPProvider(String provider) {
        return "YET_PROVIDER_UDP".equals(provider);
    }

    protected boolean useTCPProvider(String provider) {
        return "YET_PROVIDER_TCP".equals(provider);
    }

    protected YETUDPPort provideUDPPort(Injector injector) {
        if (UDP_PORT_MAP == null) {
            UDP_PORT_MAP = new HashMap<Integer, YETUDPPort>();
        }
        int portNumber = this.getUDPPort();
        YETUDPPort port = new YETUDPPort();
        injector.injectMembers((Object)port);
        return UDP_PORT_MAP.merge(portNumber, port, (inMap, newValue) -> inMap);
    }

    protected YETTCPPort provideTCPPort(Injector injector) {
        if (TCP_PORT_MAP == null) {
            TCP_PORT_MAP = new HashMap<Integer, YETTCPPort>();
        }
        int portNumber = this.getTCPPort();
        YETTCPPort port = new YETTCPPort();
        injector.injectMembers((Object)port);
        return TCP_PORT_MAP.merge(portNumber, port, (inMap, newValue) -> {
            if (!inMap.isRunning()) {
                return newValue;
            }
            return inMap;
        });
    }
}

