/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.yet.sct.debugger.launch;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.util.Modules;
import com.yakindu.base.expressions.interpreter.base.IInstanceFactory;
import com.yakindu.base.expressions.interpreter.base.IInterpreter;
import com.yakindu.sct.license.LicenseChecker;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.simulation.core.sexec.container.ISimulationEngineFactory;
import com.yakindu.sct.simulation.core.sexec.interpreter.SexecInterpreter;
import com.yakindu.sct.simulation.core.sexec.launch.SexecLaunchConfigurationDelegate;
import com.yakindu.yet.core.YETTrace;
import com.yakindu.yet.core.config.IYETConfigParameters;
import com.yakindu.yet.sct.debugger.interpreter.YETInstancefactory;
import com.yakindu.yet.sct.debugger.interpreter.YETInterpreter;
import com.yakindu.yet.sct.debugger.launch.LaunchConfigurationModule;
import com.yakindu.yet.sct.debugger.launch.YETSimulationEngineFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;

public class YETLaunchConfigurationDelegate
extends SexecLaunchConfigurationDelegate
implements IYETConfigParameters {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        super.launch(configuration, mode, launch, monitor);
    }

    protected boolean isLicenseValid() {
        return new LicenseChecker().checkProfessionalLicense().isValidOrTrial();
    }

    protected Module getInjectionModule(final Statechart statechart, ILaunch launch) {
        String projectName = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(statechart.eResource().getURI().toPlatformString(true))).getProject().getName();
        Module module = super.getInjectionModule(statechart, launch);
        Module override = Modules.override((Module[])new Module[]{module}).with(new Module[]{new Module(){

            public void configure(Binder binder) {
                binder.bind(ISimulationEngineFactory.class).to(YETSimulationEngineFactory.class);
                binder.bind(Statechart.class).toInstance((Object)statechart);
                binder.bind(IInterpreter.class).to(YETInterpreter.class);
                binder.bind(IInterpreter.Control.class).to(YETInterpreter.class);
                binder.bind(SexecInterpreter.class).to(YETInterpreter.class);
                binder.bind(IInstanceFactory.class).to(YETInstancefactory.class).in(Singleton.class);
                binder.bind(YETTrace.class).in(Singleton.class);
            }
        }, new LaunchConfigurationModule(launch.getLaunchConfiguration(), projectName)});
        return override;
    }
}

