/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.simulation.debugging.ui;

import com.yakindu.sct.simulation.debugging.ISCTBreakpoint;
import com.yakindu.sct.simulation.debugging.SCTBreakpoint;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class ToggleBreakpointCommand
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IGraphicalEditPart selectedEditPart = this.unwrap(selection);
        EObject object = selectedEditPart.resolveSemanticElement();
        ISCTBreakpoint existingBreakpoint = this.findExistingBreakpoint(object);
        if (existingBreakpoint != null) {
            try {
                existingBreakpoint.delete();
                return null;
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        SCTBreakpoint breakpoint = new SCTBreakpoint(object);
        breakpoint.setNotationViewURI(EcoreUtil.getURI((EObject)selectedEditPart.getNotationView()).fragment().toString());
        try {
            DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)breakpoint);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected ISCTBreakpoint findExistingBreakpoint(EObject object) {
        IBreakpoint[] breakpoints;
        IBreakpoint[] iBreakpointArray = breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("com.yakindu.sct.simulation.core.sct.breakpoints");
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint iBreakpoint = iBreakpointArray[n2];
            if (iBreakpoint instanceof ISCTBreakpoint && EcoreUtil.getURI((EObject)object).equals(((ISCTBreakpoint)iBreakpoint).getSemanticURI())) {
                return (ISCTBreakpoint)iBreakpoint;
            }
            ++n2;
        }
        return null;
    }

    public IGraphicalEditPart unwrap(ISelection selection) {
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        Object firstElement = structuredSelection.getFirstElement();
        if (firstElement == null) {
            return null;
        }
        return (IGraphicalEditPart)firstElement;
    }
}

