/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.domain.java.resource;

import com.google.inject.Inject;
import com.yakindu.base.types.scoping.IPackageImport2URIMapper;
import com.yakindu.sct.domain.java.resource.ArchiveURI;
import com.yakindu.sct.model.stext.scoping.AbstractPackageImportUriMapper;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.core.search.TypeNameMatchRequestor;
import org.eclipse.jdt.internal.core.JrtPackageFragmentRoot;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;

public class JavaPackageImport2URIMapper
extends AbstractPackageImportUriMapper
implements IPackageImport2URIMapper {
    @Inject
    protected IQualifiedNameConverter converter;

    public Optional<IPackageImport2URIMapper.PackageImport> findPackageImport(final Resource context, final String packageImport) {
        final SearchEngine searchEngine = new SearchEngine();
        if (packageImport == null || packageImport.isEmpty()) {
            return Optional.empty();
        }
        try {
            return (Optional)TransactionUtil.runExclusive((TransactionalEditingDomain)this.getSharedEditingDomain(), (RunnableWithResult)new RunnableWithResult.Impl<Optional<IPackageImport2URIMapper.PackageImport>>(){

                public void run() {
                    IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{JavaCore.create((IProject)WorkspaceSynchronizer.getFile((Resource)JavaPackageImport2URIMapper.this.getContextResource(context)).getProject())});
                    QualifiedName qualifiedName = JavaPackageImport2URIMapper.this.converter.toQualifiedName(packageImport);
                    PackageImportListBasedAcceptor acceptor = new PackageImportListBasedAcceptor(JavaPackageImport2URIMapper.this.getProjectName(context));
                    try {
                        searchEngine.searchAllTypeNames(qualifiedName.skipLast(1).toString().toCharArray(), 2, qualifiedName.getLastSegment().toCharArray(), 2, 0, scope, (TypeNameMatchRequestor)acceptor, 3, null);
                        if (acceptor.getResult().size() > 0) {
                            this.setResult(Optional.of(acceptor.getResult().iterator().next()));
                        } else {
                            this.setResult(Optional.empty());
                        }
                    }
                    catch (CoreException e1) {
                        e1.printStackTrace();
                    }
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    public Set<IPackageImport2URIMapper.PackageImport> getAllImports(Resource context) {
        SearchEngine searchEngine = new SearchEngine();
        IJavaProject javaProject = JavaCore.create((IProject)WorkspaceSynchronizer.getFile((Resource)this.getContextResource(context)).getProject());
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{javaProject});
        PackageImportListBasedAcceptor requestor = new PackageImportListBasedAcceptor(this.getProjectName(context));
        try {
            searchEngine.searchAllTypeNames("*".toCharArray(), 2, "*".toCharArray(), 2, 0, scope, (TypeNameMatchRequestor)requestor, 1, null);
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        return requestor.getResult();
    }

    protected String getProjectName(Resource contextResource) {
        return WorkspaceSynchronizer.getFile((Resource)this.getContextResource(contextResource)).getProject().getName();
    }

    public static class JavaPackageImport
    extends IPackageImport2URIMapper.PackageImport {
        protected TypeNameMatch originalMatch;

        public JavaPackageImport(String name, URI uri, String namespace) {
            super(name, uri, namespace);
        }

        public JavaPackageImport(String name, URI uri, String namespace, TypeNameMatch originalMatch) {
            super(name, uri, namespace);
            this.originalMatch = originalMatch;
        }

        public TypeNameMatch getOriginalMatch() {
            return this.originalMatch;
        }
    }

    protected static class PackageImportListBasedAcceptor
    extends TypeNameMatchRequestor {
        Set<JavaPackageImport> result = new HashSet<JavaPackageImport>();
        private String contextProject;

        public PackageImportListBasedAcceptor(String contextProject) {
            this.contextProject = contextProject;
        }

        public void acceptTypeNameMatch(TypeNameMatch match) {
            if (match.getAccessibility() == 0 && (match.getModifiers() & 1) == 1) {
                if (match.getPackageFragmentRoot().isArchive()) {
                    this.addArchiveUriImport(match);
                } else if (!match.getPackageFragmentRoot().isExternal()) {
                    this.addResourceUriImport(match);
                }
            }
        }

        protected void addResourceUriImport(TypeNameMatch match) {
            IResource resource = match.getType().getResource();
            this.result.add(new JavaPackageImport(match.getFullyQualifiedName(), URI.createPlatformResourceURI((String)resource.getFullPath().toString(), (boolean)true), match.getPackageName(), match));
        }

        protected void addArchiveUriImport(TypeNameMatch match) {
            ArrayList<String> segments = new ArrayList<String>();
            segments.addAll(Arrays.asList(match.getPackageName().split("\\.")));
            segments.add(match.getSimpleTypeName() + ".class");
            IPackageFragmentRoot packageFragmentRoot = match.getPackageFragmentRoot();
            URI resourceUri = null;
            if (packageFragmentRoot instanceof JrtPackageFragmentRoot) {
                FileSystem jrtFileSystem = FileSystems.getFileSystem(java.net.URI.create("jrt:/"));
                Path objClassFilePath = jrtFileSystem.getPath("modules", new String(((JrtPackageFragmentRoot)packageFragmentRoot).getModule().name()), match.getFullyQualifiedName().replace('.', '/') + ".class");
                java.net.URI classFileURI = objClassFilePath.toUri();
                resourceUri = URI.createURI((String)classFileURI.toString()).appendQuery(this.contextProject);
            } else {
                resourceUri = ArchiveURI.create(match.getPackageFragmentRoot(), segments).appendQuery(this.contextProject);
            }
            if (URIConverter.INSTANCE.exists(resourceUri.trimQuery(), null)) {
                this.result.add(new JavaPackageImport(match.getFullyQualifiedName(), resourceUri, match.getPackageName(), match));
            }
        }

        public Set<IPackageImport2URIMapper.PackageImport> getResult() {
            return new HashSet<IPackageImport2URIMapper.PackageImport>(this.result);
        }
    }
}

