/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.domain.java.resource.trafo.types;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.yakindu.base.types.Type;
import com.yakindu.base.types.TypeParameter;
import com.yakindu.base.types.TypeSpecifier;
import com.yakindu.base.types.TypesFactory;
import com.yakindu.base.types.typesystem.ITypeSystem;
import com.yakindu.sct.domain.java.resource.trafo.types.ProxyBuilder;
import com.yakindu.sct.domain.java.resource.trafo.types.TypeScope;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.Signature;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

@Singleton
public class TypeLookup {
    @Inject
    protected ITypeSystem ts;
    @Inject
    protected TypeScope typeScope;
    @Inject
    protected ProxyBuilder proxyBuilder;
    protected URI uri;

    public Type fromTypeSystem(String name) {
        return this.ts.getType(name);
    }

    public void push() {
        this.typeScope.push();
    }

    public void pop() {
        this.typeScope.pop();
    }

    public void setURI(URI uri) {
        this.uri = uri;
    }

    public void registerType(IJavaProject project, String name, Type type) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = project.getProject().getName();
        _builder.append(_name);
        _builder.append("#");
        _builder.append(name);
        String projectQualifiedName = _builder.toString();
        this.typeScope.put(projectQualifiedName, type);
    }

    public Type fromSignature(IType type, String typeSignature) {
        return this.doResolve((IJavaElement)type.getJavaProject(), Signature.toString((String)typeSignature), type);
    }

    public Iterable<String> superTypeSignatures(IType type) {
        try {
            ArrayList _xblockexpression = null;
            ArrayList ret = CollectionLiterals.newArrayList();
            String scTs = type.getSuperclassTypeSignature();
            if (scTs != null) {
                ret.add(scTs);
            }
            List _list = IterableExtensions.toList((Iterable)((Iterable)Conversions.doWrapArray((Object)type.getSuperInterfaceTypeSignatures())));
            Iterables.addAll((Collection)ret, (Iterable)_list);
            _xblockexpression = ret;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected Type _resolveType(IType it) {
        return this.loadType(it.getJavaProject(), it.getFullyQualifiedName());
    }

    protected Type _resolveType(IMethod it) {
        return this.doResolve((IJavaElement)it, this.typeSignature(it), this.declaringType(it));
    }

    protected Type _resolveType(ILocalVariable it) {
        return this.doResolve((IJavaElement)it, this.typeSignature(it), this.declaringType(it));
    }

    protected Type _resolveType(IField it) {
        return this.doResolve((IJavaElement)it, this.typeSignature(it), this.declaringType(it));
    }

    protected Type _resolveType(ITypeParameter it) {
        return this.typeScope.get(it.getElementName());
    }

    protected int _arrayDepth(ILocalVariable it) {
        return Signature.getArrayCount((String)it.getTypeSignature());
    }

    protected int _arrayDepth(IField it) {
        try {
            return Signature.getArrayCount((String)it.getTypeSignature());
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected int _arrayDepth(IMethod it) {
        try {
            return Signature.getArrayCount((String)it.getReturnType());
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected Type doResolve(IJavaElement it, String signature, IType declaringType) {
        Type _xblockexpression = null;
        String fqn = this.resolveFullyQualifiedName(it.getJavaProject(), declaringType, signature);
        _xblockexpression = this.loadType(it.getJavaProject(), fqn);
        return _xblockexpression;
    }

    public Collection<Type> getTypeArguments(IField field) {
        try {
            return this.getTypeArguments(field.getJavaProject(), field.getTypeSignature(), field.getDeclaringType());
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public Collection<Type> getTypeArguments(ILocalVariable variable) {
        return this.getTypeArguments(variable.getJavaProject(), variable.getTypeSignature(), this.declaringType(variable));
    }

    public Collection<Type> getTypeArguments(IMethod method) {
        try {
            return this.getTypeArguments(method.getJavaProject(), method.getReturnType(), method.getDeclaringType());
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public Collection<Type> getTypeArguments(IJavaProject project, String signature, IType declaringType) {
        Functions.Function1 _function = it -> {
            Type _xblockexpression = null;
            String pretty = Signature.toString((String)it);
            Type _xifexpression = null;
            if (Signature.getTypeSignatureKind((String)it) == 5 && it.startsWith(Character.valueOf('+').toString())) {
                TypeParameter _xblockexpression_1 = null;
                pretty = pretty.replace("? extends ", "");
                Type namedType = this.doResolve((IJavaElement)project, pretty, declaringType);
                TypeParameter type = TypesFactory.eINSTANCE.createTypeParameter();
                type.setName("?");
                TypeSpecifier ts = TypesFactory.eINSTANCE.createTypeSpecifier();
                ts.setType(namedType);
                EList _superTypes = type.getSuperTypes();
                _superTypes.add((Object)ts);
                _xblockexpression_1 = type;
                _xifexpression = _xblockexpression_1;
            } else {
                Type namedType;
                Type _xblockexpression_2 = null;
                _xifexpression = _xblockexpression_2 = (namedType = this.doResolve((IJavaElement)project, pretty, declaringType));
            }
            _xblockexpression = _xifexpression;
            return _xblockexpression;
        };
        return IterableExtensions.toList((Iterable)ListExtensions.map((List)((List)Conversions.doWrapArray((Object)Signature.getTypeArguments((String)signature))), (Functions.Function1)_function));
    }

    protected String resolveFullyQualifiedName(IJavaProject project, IType declaringType, String signature) {
        boolean _tripleNotEquals;
        Type _type = this.ts.getType(signature);
        boolean bl = _tripleNotEquals = _type != null;
        if (_tripleNotEquals) {
            return signature;
        }
        boolean _isBinary = declaringType.isBinary();
        if (_isBinary) {
            return Signature.getTypeErasure((String)signature);
        }
        return this.buildResolvedName(project, declaringType, signature);
    }

    protected String buildResolvedName(IJavaProject project, IType declaringType, String signature) {
        try {
            String[][] resolved = declaringType.resolveType(signature);
            if (resolved == null || resolved.length == 0 || resolved[0] == null) {
                return signature;
            }
            Functions.Function1 _function = it -> {
                boolean _isEmpty = it.isEmpty();
                return !_isEmpty;
            };
            String result = IterableExtensions.join((Iterable)IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)resolved[0])), (Functions.Function1)_function), (CharSequence)".");
            IType type = project.findType(result);
            return type.getFullyQualifiedName();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected String _typeSignature(IMethod it) {
        try {
            String _xblockexpression = null;
            String signature = Signature.getTypeErasure((String)it.getReturnType());
            signature = Signature.getElementType((String)signature);
            _xblockexpression = signature = Signature.toString((String)signature);
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected String _typeSignature(IField it) {
        try {
            return Signature.toString((String)Signature.getElementType((String)it.getTypeSignature()));
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected String _typeSignature(ILocalVariable it) {
        return Signature.toString((String)Signature.getElementType((String)it.getTypeSignature()));
    }

    protected IType _declaringType(IMethod it) {
        return it.getDeclaringType();
    }

    protected IType _declaringType(IField it) {
        return it.getDeclaringType();
    }

    protected IType _declaringType(ILocalVariable it) {
        return it.getDeclaringMember().getDeclaringType();
    }

    protected Type loadType(IJavaProject project, String typeName) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = project.getProject().getName();
        _builder.append(_name);
        _builder.append("#");
        _builder.append(typeName);
        String projectQualifiedName = _builder.toString();
        Type type = this.ts.getType(typeName);
        if (type != null) {
            return type;
        }
        type = this.typeScope.get(projectQualifiedName);
        if (type != null) {
            return type;
        }
        type = this.proxyBuilder.build(typeName, project);
        this.typeScope.put(projectQualifiedName, type);
        return type;
    }

    @XbaseGenerated
    public Type resolveType(Object it) {
        if (it instanceof IField) {
            return this._resolveType((IField)it);
        }
        if (it instanceof IMethod) {
            return this._resolveType((IMethod)it);
        }
        if (it instanceof IType) {
            return this._resolveType((IType)it);
        }
        if (it instanceof ILocalVariable) {
            return this._resolveType((ILocalVariable)it);
        }
        if (it instanceof ITypeParameter) {
            return this._resolveType((ITypeParameter)it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    @XbaseGenerated
    public int arrayDepth(Object it) {
        if (it instanceof IField) {
            return this._arrayDepth((IField)it);
        }
        if (it instanceof IMethod) {
            return this._arrayDepth((IMethod)it);
        }
        if (it instanceof ILocalVariable) {
            return this._arrayDepth((ILocalVariable)it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    @XbaseGenerated
    protected String typeSignature(Object it) {
        if (it instanceof IField) {
            return this._typeSignature((IField)it);
        }
        if (it instanceof IMethod) {
            return this._typeSignature((IMethod)it);
        }
        if (it instanceof ILocalVariable) {
            return this._typeSignature((ILocalVariable)it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    @XbaseGenerated
    protected IType declaringType(Object it) {
        if (it instanceof IField) {
            return this._declaringType((IField)it);
        }
        if (it instanceof IMethod) {
            return this._declaringType((IMethod)it);
        }
        if (it instanceof ILocalVariable) {
            return this._declaringType((ILocalVariable)it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }
}

