/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.domain.java.resource.trafo.types;

import com.google.inject.Singleton;
import com.yakindu.base.types.Type;
import com.yakindu.base.types.TypeParameter;
import java.util.HashMap;
import java.util.Map;

@Singleton
public class TypeScope {
    protected TypeScopeStack stack = new TypeScopeStack();

    public Type put(String name, Type type) {
        if (type instanceof TypeParameter) {
            return this.stack.addTypeToMap(name, type);
        }
        return this.stack.addTypeToGlobalMap(name, type);
    }

    public Type remove(String name) {
        return this.stack.removeTypeFromMap(name);
    }

    public Type get(String name) {
        return this.stack.getType(name);
    }

    public void clear() {
        while (this.pop()) {
        }
        this.stack.clearMap();
    }

    public boolean pop() {
        TypeScopeStack newStack = this.stack.pop();
        if (newStack != null) {
            this.stack = newStack;
            return true;
        }
        return false;
    }

    public void push() {
        this.stack = this.stack.push();
    }

    public String toString() {
        return this.stack.toString();
    }

    private class TypeScopeStack {
        protected TypeScopeStack lastElement;
        Map<String, Type> typeMap;

        public TypeScopeStack() {
            this.lastElement = null;
            this.typeMap = new HashMap<String, Type>();
        }

        private TypeScopeStack(TypeScopeStack lastElement) {
            this.lastElement = lastElement;
            this.typeMap = new HashMap<String, Type>(lastElement.typeMap);
        }

        public TypeScopeStack pop() {
            return this.lastElement;
        }

        public TypeScopeStack push() {
            return new TypeScopeStack(this);
        }

        private Type addTypeToMap(String name, Type type) {
            return this.typeMap.put(name, type);
        }

        private Type addTypeToGlobalMap(String name, Type type) {
            Type ret = this.addTypeToMap(name, type);
            if (this.lastElement != null) {
                return this.lastElement.addTypeToGlobalMap(name, type);
            }
            return ret;
        }

        private Type removeTypeFromMap(String name) {
            return this.typeMap.remove(name);
        }

        private Type getType(String name) {
            return this.typeMap.get(name);
        }

        private void clearMap() {
            this.typeMap.clear();
        }

        public String toString() {
            return this.typeMap.toString();
        }
    }
}

