/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.domain.java.typesystem;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.inject.Singleton;
import com.yakindu.base.types.Type;
import com.yakindu.base.types.typesystem.GenericTypeSystem;

@Singleton
public class JavaTypeSystem
extends GenericTypeSystem {
    public static final String BYTE = "byte";
    public static final String CHARACTER = "char";
    public static final String DOUBLE = "double";
    public static final String FLOAT = "float";
    public static final String INT = "int";
    public static final String LONG = "long";
    public static final String SHORT = "short";
    public static final String VOID = "void";
    public static final String NULL = "null";
    public static final String CONSTRUCTOR = "new";
    private static final JavaTypeSystem INSTANCE = new JavaTypeSystem();
    private BiMap<String, String> boxingMap;

    public static JavaTypeSystem getInstance() {
        return INSTANCE;
    }

    protected void initRegistries() {
        super.initRegistries();
        this.getType("real").setAbstract(true);
        this.getType("integer").setAbstract(true);
        this.getType("string").setAbstract(true);
        this.getType("array").setAbstract(false);
        this.declarePrimitive(BYTE);
        this.declarePrimitive(CHARACTER);
        this.declarePrimitive(DOUBLE);
        this.declarePrimitive(FLOAT);
        this.declarePrimitive(INT);
        this.declarePrimitive(LONG);
        this.declarePrimitive(SHORT);
        this.declarePrimitive(VOID);
        this.declarePrimitive(NULL);
        this.declareSuperType(this.getType(DOUBLE), this.getType("real"));
        this.declareSuperType(this.getType(FLOAT), this.getType(DOUBLE));
        this.declareSuperType(this.getType("integer"), this.getType(FLOAT));
        this.declareSuperType(this.getType(LONG), this.getType("integer"));
        this.declareSuperType(this.getType(INT), this.getType(LONG));
        this.declareSuperType(this.getType(SHORT), this.getType(INT));
        this.declareSuperType(this.getType(BYTE), this.getType(SHORT));
        this.enableAutoBoxing();
    }

    public String enableAutoBoxing() {
        String _xblockexpression = null;
        this.boxingMap = HashBiMap.create();
        this.declareBoxConversion(Boolean.class.getName(), "boolean");
        this.declareBoxConversion(Byte.class.getName(), BYTE);
        this.declareBoxConversion(Character.class.getName(), CHARACTER);
        this.declareBoxConversion(Double.class.getName(), DOUBLE);
        this.declareBoxConversion(Float.class.getName(), FLOAT);
        this.declareBoxConversion(Integer.class.getName(), INT);
        this.declareBoxConversion(Long.class.getName(), LONG);
        this.declareBoxConversion(Short.class.getName(), SHORT);
        _xblockexpression = this.declareBoxConversion(String.class.getName(), "string");
        return _xblockexpression;
    }

    protected String declareBoxConversion(String type1, String type2) {
        return (String)this.boxingMap.put((Object)type1, (Object)type2);
    }

    public boolean isConvertableTo(Type type1, Type type2) {
        return this.isBoxConvertableTo(type1, type2) || super.isConvertableTo(type1, type2);
    }

    protected Type getConversionType(Type sourceType) {
        Type convType = super.getConversionType(sourceType);
        if (convType == null) {
            return this.getType((String)this.boxingMap.get((Object)sourceType.getId()));
        }
        return null;
    }

    protected boolean isBoxConvertableTo(Type type1, Type type2) {
        boolean _tripleEquals;
        boolean _or = false;
        String _id = null;
        if (type1 != null) {
            _id = type1.getId();
        }
        boolean bl = _tripleEquals = _id == null;
        if (_tripleEquals) {
            _or = true;
        } else {
            boolean _tripleEquals_1;
            String _id_1 = null;
            if (type2 != null) {
                _id_1 = type2.getId();
            }
            _or = _tripleEquals_1 = _id_1 == null;
        }
        if (_or) {
            return false;
        }
        return this.isBoxConvertableToSubType(type1, type2) || this.isBoxConvertableToSubType(type2, type1);
    }

    protected boolean isBoxConvertableToSubType(Type type1, Type type2) {
        boolean _isSuperType;
        String conversionTypeName = (String)this.boxingMap.get((Object)type1.getId());
        Type conversionType = this.getType(conversionTypeName);
        if (conversionType != null && (_isSuperType = this.isSuperType(conversionType, type2))) {
            return true;
        }
        return type2.getId().equals(conversionTypeName);
    }
}

