/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.scxml;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.yakindu.base.base.DocumentedElement;
import com.yakindu.base.expressions.expressions.EventSpec;
import com.yakindu.base.expressions.expressions.Guard;
import com.yakindu.base.expressions.expressions.ReactionTrigger;
import com.yakindu.base.expressions.expressions.RegularEventSpec;
import com.yakindu.base.expressions.expressions.TimeEventSpec;
import com.yakindu.base.types.Effect;
import com.yakindu.base.types.Expression;
import com.yakindu.base.types.Trigger;
import com.yakindu.sct.generator.core.ISGraphGenerator;
import com.yakindu.sct.generator.scxml.SCXMLDataModelGenerator;
import com.yakindu.sct.generator.scxml.SCXMLExpressions;
import com.yakindu.sct.generator.scxml.SCXMLModelModifications;
import com.yakindu.sct.generator.scxml.SCXMLReactiveElementGenerator;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import com.yakindu.sct.model.sgraph.Choice;
import com.yakindu.sct.model.sgraph.Entry;
import com.yakindu.sct.model.sgraph.EntryKind;
import com.yakindu.sct.model.sgraph.Exit;
import com.yakindu.sct.model.sgraph.FinalState;
import com.yakindu.sct.model.sgraph.Reaction;
import com.yakindu.sct.model.sgraph.Region;
import com.yakindu.sct.model.sgraph.ScopedElement;
import com.yakindu.sct.model.sgraph.State;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.sgraph.Synchronization;
import com.yakindu.sct.model.sgraph.Transition;
import com.yakindu.sct.model.sgraph.Vertex;
import com.yakindu.sct.model.stext.stext.BuiltinEventSpec;
import com.yakindu.sct.model.stext.stext.DefaultTrigger;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class SCXMLGenerator
implements ISGraphGenerator {
    @Inject
    protected SCXMLModelModifications modifications;
    @Inject
    protected SCXMLDataModelGenerator dataModel;
    @Inject
    @Extension
    protected IQualifiedNameProvider _iQualifiedNameProvider;
    @Inject
    @Extension
    protected SCXMLExpressions _sCXMLExpressions;
    @Inject
    @Extension
    protected SCXMLReactiveElementGenerator reactiveElementGenerator;

    public void generate(Statechart sc, GeneratorEntry entry, IFileSystemAccess fsa) {
        Statechart scCopy = this.modifications.modify(sc);
        String _name = scCopy.getName();
        String _plus = _name + ".scxml";
        CharSequence _generate = this.generate((EObject)scCopy);
        fsa.generateFile(_plus, (CharSequence)((String)_generate));
    }

    protected String _generate(Statechart it) {
        boolean _greaterThan_1;
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        _builder.newLine();
        CharSequence _generateDocumentation = this.generateDocumentation((DocumentedElement)it);
        _builder.append((Object)_generateDocumentation);
        _builder.newLineIfNotEmpty();
        _builder.append("<scxml xmlns=\"http://www.w3.org/2005/07/scxml\" version=\"1.0\" datamodel=\"ecmascript\" name=\"");
        String _name = it.getName();
        _builder.append(_name);
        _builder.append("\">");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _generate = this.dataModel.generate((ScopedElement)it);
        _builder.append((Object)_generate, "\t");
        _builder.newLineIfNotEmpty();
        int _size = it.getRegions().size();
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            _builder.append("\t");
            _builder.append("<parallel>");
            _builder.newLine();
        }
        EList _regions = it.getRegions();
        for (Region region : _regions) {
            _builder.append("\t");
            _builder.append("<state id=\"");
            String _string = this._iQualifiedNameProvider.getFullyQualifiedName((EObject)region).toString();
            _builder.append(_string, "\t");
            _builder.append("\">");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            CharSequence _generate_1 = this.generate((EObject)region);
            _builder.append((Object)_generate_1, "\t\t");
            _builder.newLineIfNotEmpty();
            Region _head = (Region)IterableExtensions.head((Iterable)it.getRegions());
            boolean _equals = Objects.equals(region, _head);
            if (_equals) {
                _builder.append("\t");
                _builder.append("\t");
                CharSequence _generateLocalReactions = this.reactiveElementGenerator.generateLocalReactions((EObject)it);
                _builder.append((Object)_generateLocalReactions, "\t\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("</state>");
            _builder.newLine();
        }
        int _size_1 = it.getRegions().size();
        boolean bl2 = _greaterThan_1 = _size_1 > 1;
        if (_greaterThan_1) {
            _builder.append("\t");
            _builder.append("</parallel>");
            _builder.newLine();
        }
        _builder.append("</scxml>");
        _builder.newLine();
        return _builder.toString();
    }

    private String initialState(Region region) {
        String _xblockexpression = null;
        Entry entry = this.getDefaultEntry(region);
        if (entry != null) {
            String _xifexpression = null;
            EntryKind _kind = entry.getKind();
            boolean _equals = Objects.equals(_kind, EntryKind.INITIAL);
            _xifexpression = _equals ? this.transitionTarget(((Transition)IterableExtensions.head((Iterable)entry.getOutgoingTransitions())).getTarget()).toString() : this._iQualifiedNameProvider.getFullyQualifiedName((EObject)entry).toString();
            return _xifexpression;
        }
        _xblockexpression = "";
        return _xblockexpression;
    }

    private Entry getDefaultEntry(Region region) {
        Functions.Function1 _function = it -> it.isDefault();
        return (Entry)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)region.getVertices(), Entry.class), (Functions.Function1)_function));
    }

    protected CharSequence _generate(Region it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateInitialTransition = this.generateInitialTransition(it);
        _builder.append((Object)_generateInitialTransition);
        _builder.newLineIfNotEmpty();
        EList _vertices = it.getVertices();
        for (Vertex vertex : _vertices) {
            CharSequence _generate = this.generate((EObject)vertex);
            _builder.append((Object)_generate);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence _generate(Choice it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<state id=\"");
        String _string = this._iQualifiedNameProvider.getFullyQualifiedName((EObject)it).toString();
        _builder.append(_string);
        _builder.append("\">");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        Functions.Function1 _function = it_1 -> {
            boolean _isDefault = this.isDefault((Transition)it_1);
            return !_isDefault;
        };
        CharSequence _generateTransitions = this.generateTransitions(IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)it.getOutgoingTransitions(), (Functions.Function1)_function)));
        _builder.append((Object)_generateTransitions, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        Functions.Function1 _function_1 = it_1 -> this.isDefault((Transition)it_1);
        CharSequence _generateTransitions_1 = this.generateTransitions(IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)it.getOutgoingTransitions(), (Functions.Function1)_function_1)));
        _builder.append((Object)_generateTransitions_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("</state>");
        _builder.newLine();
        return _builder;
    }

    protected boolean isDefault(Transition transition) {
        boolean _xifexpression = false;
        Trigger _trigger = transition.getTrigger();
        if (_trigger instanceof ReactionTrigger) {
            boolean _xblockexpression = false;
            Trigger _trigger_1 = transition.getTrigger();
            ReactionTrigger reactionTrigger = (ReactionTrigger)_trigger_1;
            _xifexpression = _xblockexpression = reactionTrigger.getTriggers().isEmpty() && reactionTrigger.getGuard() == null;
        } else {
            boolean _xifexpression_1 = false;
            Trigger _trigger_1 = transition.getTrigger();
            if (_trigger_1 instanceof DefaultTrigger) {
                _xifexpression_1 = true;
            } else {
                boolean _xifexpression_2 = false;
                Trigger _trigger_2 = transition.getTrigger();
                boolean _tripleEquals = _trigger_2 == null;
                _xifexpression_2 = _tripleEquals;
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    protected CharSequence _generate(State it) {
        CharSequence _xifexpression = null;
        boolean _isOrthogonal = it.isOrthogonal();
        if (_isOrthogonal) {
            _xifexpression = this.generateParallelState(it);
        } else {
            CharSequence _xifexpression_1 = null;
            boolean _isComposite = it.isComposite();
            _xifexpression_1 = _isComposite ? this.generateCompositeState(it) : this.generateLeafState(it);
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    public CharSequence generateLeafState(State it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateDocumentation = this.generateDocumentation((DocumentedElement)it);
        _builder.append((Object)_generateDocumentation);
        _builder.newLineIfNotEmpty();
        _builder.append("<state id=\"");
        String _string = this._iQualifiedNameProvider.getFullyQualifiedName((EObject)it).toString();
        _builder.append(_string);
        _builder.append("\">");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _generate = this.dataModel.generate((ScopedElement)it);
        _builder.append((Object)_generate, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _generateLocalReactions = this.reactiveElementGenerator.generateLocalReactions((EObject)it);
        _builder.append((Object)_generateLocalReactions, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _generateOutgoingTransition = this.generateOutgoingTransition((Vertex)it);
        _builder.append((Object)_generateOutgoingTransition, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("</state>");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateCompositeState(State it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateDocumentation = this.generateDocumentation((DocumentedElement)it);
        _builder.append((Object)_generateDocumentation);
        _builder.newLineIfNotEmpty();
        _builder.append("<state id=\"");
        String _string = this._iQualifiedNameProvider.getFullyQualifiedName((EObject)it).toString();
        _builder.append(_string);
        _builder.append("\">");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _generate = this.dataModel.generate((ScopedElement)it);
        _builder.append((Object)_generate, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _generateLocalReactions = this.reactiveElementGenerator.generateLocalReactions((EObject)it);
        _builder.append((Object)_generateLocalReactions, "\t");
        _builder.newLineIfNotEmpty();
        EList _regions = it.getRegions();
        for (Region region : _regions) {
            _builder.append("\t");
            CharSequence _generate_1 = this.generate((EObject)region);
            _builder.append((Object)_generate_1, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        CharSequence _generateOutgoingTransition = this.generateOutgoingTransition((Vertex)it);
        _builder.append((Object)_generateOutgoingTransition, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("</state>");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateParallelState(State it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateDocumentation = this.generateDocumentation((DocumentedElement)it);
        _builder.append((Object)_generateDocumentation);
        _builder.newLineIfNotEmpty();
        _builder.append("<parallel id=\"");
        String _string = this._iQualifiedNameProvider.getFullyQualifiedName((EObject)it).toString();
        _builder.append(_string);
        _builder.append("\">");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _generate = this.dataModel.generate((ScopedElement)it);
        _builder.append((Object)_generate, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _generateLocalReactions = this.reactiveElementGenerator.generateLocalReactions((EObject)it);
        _builder.append((Object)_generateLocalReactions, "\t");
        _builder.newLineIfNotEmpty();
        EList _regions = it.getRegions();
        for (Region region : _regions) {
            _builder.append("\t");
            _builder.append("<state id=\"");
            String _string_1 = this._iQualifiedNameProvider.getFullyQualifiedName((EObject)region).toString();
            _builder.append(_string_1, "\t");
            _builder.append("\">");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            CharSequence _generate_1 = this.generate((EObject)region);
            _builder.append((Object)_generate_1, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("</state>");
            _builder.newLine();
        }
        _builder.append("\t");
        CharSequence _generateOutgoingTransition = this.generateOutgoingTransition((Vertex)it);
        _builder.append((Object)_generateOutgoingTransition, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("</parallel>");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _generate(Exit it) {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    protected CharSequence _generate(Reaction it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _event = this.event((EObject)it.getTrigger());
        _builder.append((Object)_event);
        _builder.append(" ");
        Trigger _trigger = it.getTrigger();
        CharSequence _condition = null;
        if (_trigger != null) {
            _condition = this.condition(_trigger);
        }
        _builder.append(_condition);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _generate(Transition it) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateDocumentation = this.generateDocumentation((DocumentedElement)it);
        _builder.append((Object)_generateDocumentation);
        _builder.newLineIfNotEmpty();
        _builder.append("<transition event=\"");
        Trigger _trigger = it.getTrigger();
        CharSequence _event = null;
        if (_trigger != null) {
            _event = this.event((EObject)_trigger);
        }
        _builder.append(_event);
        _builder.append("\" cond=\"");
        Trigger _trigger_1 = it.getTrigger();
        CharSequence _condition = null;
        if (_trigger_1 != null) {
            _condition = this.condition(_trigger_1);
        }
        _builder.append(_condition);
        _builder.append("\" target=\"");
        CharSequence _transitionTarget = this.transitionTarget(it.getTarget());
        _builder.append((Object)_transitionTarget);
        _builder.append("\">");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        Effect _effect = it.getEffect();
        boolean bl = _tripleNotEquals = _effect != null;
        if (_tripleNotEquals) {
            CharSequence _generate = this.reactiveElementGenerator.generate((EObject)it.getEffect());
            _builder.append((Object)_generate, "\t");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("</transition>");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _transitionTarget(Vertex it) {
        return this._iQualifiedNameProvider.getFullyQualifiedName((EObject)it).toString();
    }

    protected CharSequence _generate(Synchronization it) {
        return null;
    }

    protected CharSequence _transitionTarget(Synchronization it) {
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1 _function = it_1 -> it_1.getTarget();
        List _map = ListExtensions.map((List)it.getOutgoingTransitions(), (Functions.Function1)_function);
        boolean _hasElements = false;
        for (Vertex target : _map) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)" ", "");
            }
            String _string = this._iQualifiedNameProvider.getFullyQualifiedName((EObject)target).toString();
            _builder.append(_string);
        }
        return _builder;
    }

    protected CharSequence _generate(FinalState it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<final id=\"");
        String _string = this._iQualifiedNameProvider.getFullyQualifiedName((EObject)it).toString();
        _builder.append(_string);
        _builder.append("\"/>\t");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _generate(Entry it) {
        StringConcatenation _switchResult = null;
        EntryKind _kind = it.getKind();
        boolean _matched = false;
        EntryKind _kind_1 = it.getKind();
        boolean _equals = Objects.equals(_kind_1, EntryKind.DEEP_HISTORY);
        if (_equals) {
            boolean _equals_1;
            _matched = true;
            StringConcatenation _builder = new StringConcatenation();
            EList _outgoingTransitions = it.getOutgoingTransitions();
            Transition _head = null;
            if (_outgoingTransitions != null) {
                _head = (Transition)IterableExtensions.head((Iterable)_outgoingTransitions);
            }
            Effect _effect = null;
            if (_head != null) {
                _effect = _head.getEffect();
            }
            Effect effect = _effect;
            _builder.newLineIfNotEmpty();
            _builder.append("<history type=\"deep\" id=\"");
            String _string = this._iQualifiedNameProvider.getFullyQualifiedName((EObject)it).toString();
            _builder.append(_string);
            _builder.append("\">");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            CharSequence _generateOutgoingTransition = this.generateOutgoingTransition((Vertex)it);
            _builder.append((Object)_generateOutgoingTransition, "\t");
            _builder.newLineIfNotEmpty();
            int _size = it.getOutgoingTransitions().size();
            boolean bl = _equals_1 = _size == 0;
            if (_equals_1) {
                _builder.append("\t");
                _builder.append("<transition target=\"");
                String _initialState = this.initialState(it.getParentRegion());
                _builder.append(_initialState, "\t");
                _builder.append("\">");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                if (effect != null) {
                    CharSequence _generate = this.reactiveElementGenerator.generate((EObject)effect);
                    _builder.append((Object)_generate, "\t");
                }
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("</transition>");
                _builder.newLine();
            }
            _builder.append("</history>");
            _builder.newLine();
            _switchResult = _builder;
        }
        if (!_matched && Objects.equals(_kind, EntryKind.SHALLOW_HISTORY)) {
            boolean _equals_2;
            _matched = true;
            StringConcatenation _builder_1 = new StringConcatenation();
            EList _outgoingTransitions_1 = it.getOutgoingTransitions();
            Transition _head_1 = null;
            if (_outgoingTransitions_1 != null) {
                _head_1 = (Transition)IterableExtensions.head((Iterable)_outgoingTransitions_1);
            }
            Effect _effect_1 = null;
            if (_head_1 != null) {
                _effect_1 = _head_1.getEffect();
            }
            Effect effect_1 = _effect_1;
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("<history type = \"shallow\" id=\"");
            String _string_1 = this._iQualifiedNameProvider.getFullyQualifiedName((EObject)it).toString();
            _builder_1.append(_string_1);
            _builder_1.append("\">");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("\t");
            CharSequence _generateOutgoingTransition_1 = this.generateOutgoingTransition((Vertex)it);
            _builder_1.append((Object)_generateOutgoingTransition_1, "\t");
            _builder_1.newLineIfNotEmpty();
            int _size_1 = it.getOutgoingTransitions().size();
            boolean bl = _equals_2 = _size_1 == 0;
            if (_equals_2) {
                _builder_1.append("\t");
                _builder_1.append("<transition target=\"");
                String _initialState_1 = this.initialState(it.getParentRegion());
                _builder_1.append(_initialState_1, "\t");
                _builder_1.append("\">");
                _builder_1.newLineIfNotEmpty();
                _builder_1.append("\t");
                if (effect_1 != null) {
                    CharSequence _generate_1 = this.reactiveElementGenerator.generate((EObject)effect_1);
                    _builder_1.append((Object)_generate_1, "\t");
                }
                _builder_1.newLineIfNotEmpty();
                _builder_1.append("\t");
                _builder_1.append("</transition>");
                _builder_1.newLine();
            }
            _builder_1.append("</history>");
            _builder_1.newLine();
            _switchResult = _builder_1;
        }
        if (!_matched && Objects.equals(_kind, EntryKind.INITIAL)) {
            StringConcatenation _builder_2;
            _matched = true;
            _switchResult = _builder_2 = new StringConcatenation();
        }
        return _switchResult;
    }

    protected CharSequence _event(ReactionTrigger it) {
        StringConcatenation _builder = new StringConcatenation();
        EList _triggers = it.getTriggers();
        boolean _hasElements = false;
        for (EventSpec trigger : _triggers) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            CharSequence _event = this.event((EObject)trigger);
            _builder.append((Object)_event);
        }
        return _builder;
    }

    protected CharSequence _event(BuiltinEventSpec it) {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    protected CharSequence _event(TimeEventSpec it) {
        StringConcatenation _builder = new StringConcatenation();
        QualifiedName _fullyQualifiedName = this._iQualifiedNameProvider.getFullyQualifiedName((EObject)it);
        _builder.append((Object)_fullyQualifiedName);
        return _builder;
    }

    protected CharSequence _event(RegularEventSpec it) {
        StringConcatenation _builder = new StringConcatenation();
        Expression _event = it.getEvent();
        CharSequence _code = null;
        if (_event != null) {
            _code = this._sCXMLExpressions.code((EObject)_event);
        }
        _builder.append(_code);
        return _builder;
    }

    protected CharSequence _event(DefaultTrigger it) {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    protected CharSequence _condition(ReactionTrigger it) {
        StringConcatenation _builder = new StringConcatenation();
        Guard _guard = it.getGuard();
        Expression _expression = null;
        if (_guard != null) {
            _expression = _guard.getExpression();
        }
        CharSequence _code = null;
        if (_expression != null) {
            _code = this._sCXMLExpressions.code((EObject)_expression);
        }
        _builder.append(_code);
        return _builder;
    }

    protected CharSequence _condition(DefaultTrigger it) {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    protected CharSequence _generate(EObject it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Missig dispatch for ");
        _builder.append((Object)it);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence generateInitialTransition(Region it) {
        StringConcatenation _builder = new StringConcatenation();
        Entry _defaultEntry = this.getDefaultEntry(it);
        EList _outgoingTransitions = null;
        if (_defaultEntry != null) {
            _outgoingTransitions = _defaultEntry.getOutgoingTransitions();
        }
        Transition _head = null;
        if (_outgoingTransitions != null) {
            _head = (Transition)IterableExtensions.head((Iterable)_outgoingTransitions);
        }
        Effect _effect = null;
        if (_head != null) {
            _effect = _head.getEffect();
        }
        Effect effect = _effect;
        _builder.newLineIfNotEmpty();
        _builder.append("<initial>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<transition target=\"");
        String _initialState = this.initialState(it);
        _builder.append(_initialState, "\t");
        _builder.append("\" type=\"internal\">");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        if (effect != null) {
            CharSequence _generate = this.reactiveElementGenerator.generate((EObject)effect);
            _builder.append((Object)_generate, "\t");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("</transition>");
        _builder.newLine();
        _builder.append("</initial>");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence generateOutgoingTransition(Vertex vertex) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateTransitions = this.generateTransitions((List<Transition>)vertex.getOutgoingTransitions());
        _builder.append((Object)_generateTransitions);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence generateTransitions(List<Transition> transitions) {
        StringConcatenation _builder = new StringConcatenation();
        for (Transition transition : transitions) {
            String _removeEmptyAttributes = this.removeEmptyAttributes(this.generate((EObject)transition).toString());
            _builder.append(_removeEmptyAttributes);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected String removeEmptyAttributes(String it) {
        return it.replaceAll("cond=\"\"", "").replaceAll("event=\"\"", "");
    }

    protected CharSequence generateDocumentation(DocumentedElement it) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)it.getDocumentation());
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            _builder.append("<!-- ");
            String _escapeXml = StringEscapeUtils.escapeXml((String)it.getDocumentation());
            _builder.append(_escapeXml);
            _builder.append(" -->");
        }
        return _builder;
    }

    @XbaseGenerated
    public CharSequence generate(EObject it) {
        if (it instanceof Transition) {
            return this._generate((Transition)it);
        }
        if (it instanceof Reaction) {
            return this._generate((Reaction)it);
        }
        if (it instanceof Choice) {
            return this._generate((Choice)it);
        }
        if (it instanceof Entry) {
            return this._generate((Entry)it);
        }
        if (it instanceof Exit) {
            return this._generate((Exit)it);
        }
        if (it instanceof FinalState) {
            return this._generate((FinalState)it);
        }
        if (it instanceof State) {
            return this._generate((State)it);
        }
        if (it instanceof Synchronization) {
            return this._generate((Synchronization)it);
        }
        if (it instanceof Region) {
            return this._generate((Region)it);
        }
        if (it instanceof Statechart) {
            return this._generate((Statechart)it);
        }
        if (it != null) {
            return this._generate(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    @XbaseGenerated
    protected CharSequence transitionTarget(Vertex it) {
        if (it instanceof Synchronization) {
            return this._transitionTarget((Synchronization)it);
        }
        if (it != null) {
            return this._transitionTarget(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    @XbaseGenerated
    public CharSequence event(EObject it) {
        if (it instanceof ReactionTrigger) {
            return this._event((ReactionTrigger)it);
        }
        if (it instanceof RegularEventSpec) {
            return this._event((RegularEventSpec)it);
        }
        if (it instanceof TimeEventSpec) {
            return this._event((TimeEventSpec)it);
        }
        if (it instanceof BuiltinEventSpec) {
            return this._event((BuiltinEventSpec)it);
        }
        if (it instanceof DefaultTrigger) {
            return this._event((DefaultTrigger)it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    @XbaseGenerated
    public CharSequence condition(Trigger it) {
        if (it instanceof ReactionTrigger) {
            return this._condition((ReactionTrigger)it);
        }
        if (it instanceof DefaultTrigger) {
            return this._condition((DefaultTrigger)it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }
}

