/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.scxml.fsa;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.yakindu.sct.generator.core.filesystem.DefaultFileSystemAccessFactory;
import com.yakindu.sct.generator.core.filesystem.ISCTFileSystemAccess;
import com.yakindu.sct.generator.core.filesystem.PathBasedFileSystemAccess;
import com.yakindu.sct.generator.core.filesystem.PathUtil;
import com.yakindu.sct.generator.scxml.fsa.URIUtil;
import com.yakindu.sct.model.sgen.FeatureParameterValue;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Path;

public class SCXMLFileSystemAccessFactory
extends DefaultFileSystemAccessFactory {
    @Inject
    protected Injector injector;
    @Inject
    protected PathUtil util;

    public ISCTFileSystemAccess create(GeneratorEntry entry) {
        ISCTFileSystemAccess fsa;
        if (this.getTargetProject(entry) != null) {
            fsa = (ISCTFileSystemAccess)this.fileSystemProvider.get();
            this.initTargetProject(fsa, entry);
            this.initDefaultOutput(fsa, entry);
        } else {
            fsa = (ISCTFileSystemAccess)this.injector.getInstance(PathBasedFileSystemAccess.class);
            fsa.setContext(this.getContextPath(entry));
            this.initDefaultOutput(fsa, entry);
        }
        return fsa;
    }

    protected String getContextPath(GeneratorEntry entry) {
        FeatureParameterValue targetFolderValue = this.getTargetFolder(entry);
        if (targetFolderValue != null && this.isAbsolutePath(targetFolderValue.getStringValue())) {
            return "";
        }
        return this.getAbsolutePath(entry);
    }

    protected FeatureParameterValue getTargetProject(GeneratorEntry entry) {
        return entry.getFeatureParameterValue("Outlet", "targetProject");
    }

    protected FeatureParameterValue getTargetFolder(GeneratorEntry entry) {
        return entry.getFeatureParameterValue("Outlet", "targetFolder");
    }

    protected String getAbsolutePath(GeneratorEntry entry) {
        IFile sgenFile = URIUtil.toFile(entry.eResource().getURI());
        return sgenFile.getParent().getLocation().toOSString();
    }

    protected boolean isAbsolutePath(String path) {
        return new Path(this.util.expand(path)).isAbsolute();
    }
}

