/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.scxml.library;

import com.yakindu.sct.generator.core.library.impl.CoreLibraryDefaultFeatureValueProvider;
import com.yakindu.sct.model.sgen.FeatureParameterValue;
import com.yakindu.sct.model.sgen.FeatureType;
import com.yakindu.sct.model.sgen.FeatureTypeLibrary;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;

public class ScxmlLibraryDefaultFeatureValueProvider
extends CoreLibraryDefaultFeatureValueProvider {
    public IStatus validateParameterValue(FeatureParameterValue parameterValue) {
        IStatus superResult = super.validateParameterValue(parameterValue);
        if (superResult != Status.OK_STATUS) {
            return superResult;
        }
        String parameterName = parameterValue.getParameter().getName();
        if ("targetProject".equals(parameterName) && !this.access.projectExists(parameterValue.getStringValue())) {
            return this.error(String.format("The Project %s does not exist.", parameterValue.getStringValue()), "error_code_missing_project");
        }
        if ("targetProject".equals(parameterName) && this.access.projectExists(parameterValue.getStringValue()) && !this.access.projectOpened(parameterValue.getStringValue())) {
            return this.error(String.format("The Project %s is not open.", parameterValue.getStringValue()));
        }
        if ("targetFolder".equals(parameterName)) {
            String targetProjectName;
            FeatureParameterValue targetProjectParam = parameterValue.getFeatureConfiguration().getParameterValue("targetProject");
            String string = targetProjectName = targetProjectParam != null ? targetProjectParam.getStringValue() : null;
            if (targetProjectName != null && !this.access.folderExists(targetProjectName, parameterValue.getStringValue())) {
                return this.warning(String.format("The Folder %s does not exist in Project %s", parameterValue.getStringValue(), targetProjectName));
            }
        }
        return Status.OK_STATUS;
    }

    public boolean isProviderFor(FeatureTypeLibrary library) {
        return library.getName().equals("Scxml");
    }

    public void setDefaultValue(FeatureType featureType, FeatureParameterValue parameterValue, EObject contextElement) {
        super.setDefaultValue(featureType, parameterValue, contextElement);
        String parameterName = parameterValue.getParameter().getName();
        if ("targetFolder".equals(parameterName)) {
            parameterValue.setValue("src-gen");
        } else if ("targetProject".equals(parameterName)) {
            parameterValue.setValue(this.getProjectName(contextElement));
        }
    }
}

