/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.domain.c.runtime.generator;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.yakindu.base.types.scoping.IPackageImport2URIMapper;
import com.yakindu.sct.commons.EMFHelper;
import com.yakindu.sct.commons.PathHelper;
import com.yakindu.sct.domain.c.runtime.resource.IncludePathImport;
import com.yakindu.sct.domain.common.ExternalIncludes;
import com.yakindu.sct.generator.c.IncludeProvider;
import com.yakindu.sct.generator.c.extensions.FileNaming;
import com.yakindu.sct.generator.c.extensions.GenmodelEntries;
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations;
import com.yakindu.sct.model.sexec.ExecutionFlow;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.stext.stext.ImportScope;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class CDomainIncludeProvider
implements IncludeProvider {
    @Inject
    @Extension
    private FileNaming _fileNaming;
    @Inject
    @Extension
    private ExternalIncludes _externalIncludes;
    @Inject
    @Extension
    private PathHelper _pathHelper;
    @Inject
    @Extension
    private GenmodelEntries _genmodelEntries;
    @Inject
    @Extension
    private GeneratorEntry entry;
    @Inject
    private IPackageImport2URIMapper includeMapper;

    public List<CharSequence> getIncludes(ExecutionFlow flow, IGenArtifactConfigurations artifactConfigs) {
        ArrayList _xblockexpression = null;
        ArrayList includes = CollectionLiterals.newArrayList();
        Set references = this._externalIncludes.includeFiles(flow);
        Iterable<IPackageImport2URIMapper.PackageImport> _packageImports = this.getPackageImports(flow);
        for (IPackageImport2URIMapper.PackageImport p : _packageImports) {
            Optional<java.nio.file.Path> path = this.usedPackageImportPath(p, references);
            boolean _isPresent = path.isPresent();
            if (!_isPresent) continue;
            CharSequence _createImport = this.createImport(p, this._pathHelper.toPathString(path.get().toFile()), artifactConfigs, flow);
            includes.add(_createImport);
        }
        _xblockexpression = includes;
        return _xblockexpression;
    }

    protected Optional<java.nio.file.Path> usedPackageImportPath(IPackageImport2URIMapper.PackageImport pkgImport, Set<String> references) {
        java.nio.file.Path symLinkPath = this._pathHelper.toPath(this.toPathString(pkgImport), new LinkOption[]{LinkOption.NOFOLLOW_LINKS});
        java.nio.file.Path resolvedPath = this._pathHelper.toPath(this.toPathString(pkgImport), new LinkOption[0]);
        boolean _generateAllIncludes = this._genmodelEntries.getGenerateAllIncludes(this.entry);
        if (_generateAllIncludes) {
            return Optional.of(symLinkPath);
        }
        Functions.Function1 _function = it -> {
            String _asKey = this.asKey((String)it);
            String _asKey_1 = this.asKey(this._pathHelper.toPathString(symLinkPath.toFile()));
            return Objects.equals(_asKey, _asKey_1);
        };
        boolean _exists = IterableExtensions.exists(references, (Functions.Function1)_function);
        if (_exists) {
            return Optional.of(symLinkPath);
        }
        Functions.Function1 _function_1 = it -> {
            String _asKey = this.asKey((String)it);
            String _asKey_1 = this.asKey(this._pathHelper.toPathString(resolvedPath.toFile()));
            return Objects.equals(_asKey, _asKey_1);
        };
        boolean _exists_1 = IterableExtensions.exists(references, (Functions.Function1)_function_1);
        if (_exists_1) {
            return Optional.of(resolvedPath);
        }
        return Optional.empty();
    }

    protected Iterable<IPackageImport2URIMapper.PackageImport> getPackageImports(ExecutionFlow flow) {
        EObject _sourceElement = flow.getSourceElement();
        Statechart statechart = (Statechart)_sourceElement;
        Functions.Function1 _function = it -> it.getImports();
        Iterable statechartImports = Iterables.concat((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)statechart.getScopes(), ImportScope.class), (Functions.Function1)_function));
        Functions.Function1 _function_1 = it -> this.includeMapper.findPackageImport(statechart.eResource(), it);
        Functions.Function1 _function_2 = it -> it.isPresent();
        Functions.Function1 _function_3 = it -> (IPackageImport2URIMapper.PackageImport)it.get();
        return IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.map((Iterable)statechartImports, (Functions.Function1)_function_1), (Functions.Function1)_function_2), (Functions.Function1)_function_3);
    }

    protected CharSequence _createImport(IPackageImport2URIMapper.PackageImport include, String headerFile, @Extension IGenArtifactConfigurations artifactConfigs, ExecutionFlow flow) {
        StringConcatenation _xblockexpression = null;
        String _relativeTo = artifactConfigs.relativeTo(headerFile, this._fileNaming.h(this._fileNaming.module(flow)));
        Path path = new Path(_relativeTo);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#include \"");
        String _string = path.toString();
        _builder.append(_string);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    protected CharSequence _createImport(IncludePathImport include, String headerFile, @Extension IGenArtifactConfigurations artifactConfigs, ExecutionFlow flow) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#include <");
        String _name = include.getName();
        _builder.append(_name);
        _builder.append(">");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected String toPathString(IPackageImport2URIMapper.PackageImport value) {
        String absPath = "NO_KEY";
        URI uri = value.getFileURI();
        boolean _isPlatform = uri.isPlatform();
        if (_isPlatform) {
            IFile iFile = EMFHelper.getIFileFromEMFUri((URI)uri);
            absPath = iFile.getLocation().toString();
        } else {
            boolean _isFile = uri.isFile();
            if (_isFile) {
                absPath = uri.toFileString();
            } else {
                String _string = value.getUri().toString();
                String _plus = "Expecting a file OR platform URI but was : " + _string;
                throw new IllegalArgumentException(_plus);
            }
        }
        return absPath;
    }

    protected String asKey(String value) {
        return value.replaceAll("\\\\", "").replaceAll("\\/", "");
    }

    @XbaseGenerated
    protected CharSequence createImport(IPackageImport2URIMapper.PackageImport include, String headerFile, IGenArtifactConfigurations artifactConfigs, ExecutionFlow flow) {
        if (include instanceof IncludePathImport) {
            return this._createImport((IncludePathImport)include, headerFile, artifactConfigs, flow);
        }
        if (include != null) {
            return this._createImport(include, headerFile, artifactConfigs, flow);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(include, headerFile, artifactConfigs, flow).toString());
    }
}

