/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.domain.c.runtime.resource;

import com.google.inject.Injector;
import com.yakindu.sct.commons.EmfUriUtil;
import com.yakindu.sct.domain.c.runtime.resource.CHeaderResource;
import com.yakindu.sct.domain.extension.DomainRegistry;
import com.yakindu.sct.domain.extension.IDomain;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.resource.IResourceFactory;

public class CHeaderResourceFactory
implements IResourceFactory {
    public Resource createResource(URI uri) {
        IDomain domain = DomainRegistry.getDomain((String)"com.yakindu.domain.c");
        if (domain != null) {
            Injector injector = this.projectHasCPPNature(uri) ? this.getInjector(domain, "org.eclipse.cdt.core.ccnature") : this.getInjector(domain, new String[0]);
            Resource resource = (Resource)injector.getInstance(CHeaderResource.class);
            resource.setURI(uri);
            return resource;
        }
        return null;
    }

    private boolean projectHasCPPNature(URI uri) {
        IFile file = EmfUriUtil.toFile((URI)uri);
        IProject project = null;
        if (file != null) {
            project = file.getProject();
        } else {
            String projectName = uri.query();
            if (projectName != null) {
                project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            }
        }
        if (project != null) {
            return this.hasCPPNature(project);
        }
        return false;
    }

    protected boolean hasCPPNature(IProject project) {
        try {
            return project.hasNature("org.eclipse.cdt.core.ccnature");
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
    }

    protected Injector getInjector(IDomain domain, String ... options) {
        return domain.getInjector("com.yakindu.sct.resource", options);
    }
}

