/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.domain.c.runtime.resource;

import com.yakindu.base.types.scoping.IPackageImport2URIMapper;
import com.yakindu.sct.domain.c.runtime.fileextensions.CDomainFileExtensions;
import com.yakindu.sct.domain.c.runtime.resource.CHeaderResource;
import com.yakindu.sct.domain.c.runtime.resource.LinkedFolderResolver;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class CHeaderToPackageImportVisitor
implements IResourceVisitor {
    private Set<IPackageImport2URIMapper.PackageImport> mapping;
    private IPath contextPath;
    private LinkedFolderResolver linkedFolderResolver = new LinkedFolderResolver();

    public void initialize(Resource context, Set<IPackageImport2URIMapper.PackageImport> mapping) {
        this.initContext(context);
        this.mapping = mapping;
    }

    public boolean visit(IResource resource) throws CoreException {
        if (resource instanceof IFile && CDomainFileExtensions.isRelevantImport(resource.getName(), resource.getProject().getName())) {
            String importLiteral = this.createContextAwareImportLiteral(resource.getFullPath(), this.contextPath);
            URI importURI = this.createEnvironmentAwareImportURI(resource);
            String importNamespace = CHeaderResource.computePackageName((IFile)resource);
            this.mapping.add(new IPackageImport2URIMapper.PackageImport(importLiteral, importURI, importNamespace));
        }
        return true;
    }

    public URI createEnvironmentAwareImportURI(IResource resource) {
        return URI.createPlatformResourceURI((String)this.linkedFolderResolver.resolve(resource).getFullPath().toString(), (boolean)true);
    }

    protected void initContext(Resource context) {
        URI contextFolder = context.getURI().trimSegments(1);
        this.contextPath = this.createContextPath(contextFolder);
    }

    protected IPath createContextPath(URI contextFolder) {
        return Path.fromOSString((String)contextFolder.toPlatformString(true));
    }

    protected String createContextAwareImportLiteral(IPath importFullPath, IPath contextPath) {
        IPath relativePathToImport = importFullPath.makeRelativeTo(contextPath);
        return relativePathToImport.toPortableString();
    }
}

