/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.domain.c.runtime.resource.transform.c;

import com.google.inject.Inject;
import com.yakindu.base.expressions.expressions.FeatureCall;
import com.yakindu.base.types.Parameter;
import com.yakindu.base.types.Type;
import com.yakindu.base.types.inferrer.ITypeSystemInferrer;
import com.yakindu.base.types.typesystem.ITypeSemantics;
import com.yakindu.base.types.typesystem.ITypeSystem;
import com.yakindu.sct.domain.c.runtime.resource.ISimpleTypeMapper;
import com.yakindu.sct.generator.c.typesystem.CTypeSystem;
import com.yakindu.sct.model.sexec.extensions.SExecExtensions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.cdt.core.dom.ast.IASTArrayDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclSpecifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class CTypeUtils {
    @Inject
    protected ITypeSystem ts;
    @Inject
    @Extension
    protected ITypeSemantics _iTypeSemantics;
    @Inject
    @Extension
    protected ITypeSystemInferrer _iTypeSystemInferrer;
    @Inject
    @Extension
    protected SExecExtensions _sExecExtensions;
    @Inject
    protected ISimpleTypeMapper mapper;
    public static final String SHARED_POINTER = "shared_ptr";
    public static final String WEAK_POINTER = "weak_ptr";
    public static final String UNIQUE_POINTER = "unique_ptr";
    public static final List<String> SMART_POINTER_TYPES = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"shared_ptr", "weak_ptr", "unique_ptr"}));

    public boolean isValueOnPointer(FeatureCall call) {
        Functions.Function1 _function = pt -> {
            boolean _isSame;
            boolean _and = false;
            ITypeSystemInferrer.InferenceResult _infer = this._iTypeSystemInferrer.infer((EObject)call.getOwner());
            Type _type = null;
            if (_infer != null) {
                _type = _infer.getType();
            }
            if (!(_isSame = this.ts.isSame(_type, this.ts.getType(pt)))) {
                _and = false;
            } else {
                boolean _equals;
                String _name = this._sExecExtensions.definition((EObject)call).getName();
                _and = _equals = Objects.equals(_name, "value");
            }
            return _and;
        };
        return IterableExtensions.exists((Iterable)CTypeSystem.POINTER_TYPES, (Functions.Function1)_function);
    }

    public boolean isBuiltInType(IASTDeclSpecifier specifier) {
        Type _builtInType = this.getBuiltInType(specifier);
        return _builtInType != null;
    }

    protected Type _getBuiltInType(IASTSimpleDeclSpecifier specifier) {
        return this.mapper.map(specifier);
    }

    protected Type _getBuiltInType(IASTNamedTypeSpecifier specifier) {
        Type type = this.ts.getType(specifier.getName().toString());
        if (type != null) {
            return type;
        }
        return this.mapper.map(specifier);
    }

    protected Type _getBuiltInType(IASTDeclSpecifier declSpecifier) {
        return null;
    }

    protected boolean _isChar(IASTSimpleDeclSpecifier specifier) {
        int _type = specifier.getType();
        return _type == 2;
    }

    protected boolean _isChar(IASTDeclSpecifier specifier) {
        return false;
    }

    public boolean isPointer(IASTDeclarator declarator) {
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)((Iterable)Conversions.doWrapArray((Object)declarator.getPointerOperators())));
        return !_isNullOrEmpty;
    }

    public boolean isSmartPointer(IASTNamedTypeSpecifier declarator) {
        return false;
    }

    protected boolean _isArray(IASTDeclarator declarator) {
        return false;
    }

    protected boolean _isArray(IASTArrayDeclarator declarator) {
        return true;
    }

    public boolean isTypedef(IASTDeclSpecifier it) {
        int _storageClass = it.getStorageClass();
        return _storageClass == 1;
    }

    public boolean isStruct(IASTCompositeTypeSpecifier it) {
        int _key = it.getKey();
        return _key == 1;
    }

    public boolean isUnion(IASTCompositeTypeSpecifier it) {
        int _key = it.getKey();
        return _key == 2;
    }

    protected boolean _isVisible(IASTCompositeTypeSpecifier declSpecifier) {
        boolean _isEmpty = declSpecifier.getName().toString().isEmpty();
        return !_isEmpty;
    }

    protected boolean _isVisible(IASTEnumerationSpecifier declSpecifier) {
        boolean _isEmpty = declSpecifier.getName().toString().isEmpty();
        return !_isEmpty;
    }

    protected boolean _isVisible(IASTDeclaration declaration) {
        return true;
    }

    public Type getArrayType() {
        return this.ts.getType("array");
    }

    public Type getPointerType() {
        return this.ts.getType("pointer");
    }

    public Type getUnsupportedType() {
        return this.ts.getType("UnsupportedType");
    }

    public boolean isVoid(Parameter parameter) {
        return this.ts.isSame(this.ts.getType("void"), parameter.getType());
    }

    public boolean isAnonymous(Type type) {
        return !type.eIsProxy() && type.getName().endsWith("$0");
    }

    protected boolean isUsed(EObject elem, Collection<?> roots) {
        boolean _xblockexpression = false;
        Functions.Function1 _function = it -> it.getEObject();
        Functions.Function1 _function_1 = e -> {
            Functions.Function1 _function_2 = it -> it == elem;
            boolean _exists = IterableExtensions.exists((Iterable)EcoreUtil2.getAllContainers((EObject)e), (Functions.Function1)_function_2);
            return !_exists;
        };
        Iterable references = IterableExtensions.filter((Iterable)IterableExtensions.map((Iterable)EcoreUtil.UsageCrossReferencer.find((EObject)elem, roots), (Functions.Function1)_function), (Functions.Function1)_function_1);
        int _size = IterableExtensions.size((Iterable)references);
        _xblockexpression = _size > 0;
        return _xblockexpression;
    }

    public IASTDeclSpecifier findParentDeclSpecifier(IASTNode node) {
        boolean _tripleEquals;
        IASTNode _parent = node.getParent();
        boolean bl = _tripleEquals = _parent == null;
        if (_tripleEquals) {
            return null;
        }
        IASTNode _parent_1 = node.getParent();
        if (_parent_1 instanceof IASTDeclSpecifier) {
            IASTNode _parent_2 = node.getParent();
            return (IASTDeclSpecifier)_parent_2;
        }
        return this.findParentDeclSpecifier(node.getParent());
    }

    public boolean isArrayType(Type valueType) {
        return this._iTypeSemantics.isBuiltInType(valueType) && "array".equals(valueType.getName());
    }

    public boolean isPointerType(Type valueType) {
        return this._iTypeSemantics.isBuiltInType(valueType) && CTypeSystem.POINTER_TYPES.contains(valueType.getName());
    }

    public boolean isSmartPointerType(Type valueType) {
        return this._iTypeSemantics.isBuiltInType(valueType) && SMART_POINTER_TYPES.contains(valueType.getName());
    }

    @XbaseGenerated
    public Type getBuiltInType(IASTDeclSpecifier specifier) {
        if (specifier instanceof IASTNamedTypeSpecifier) {
            return this._getBuiltInType((IASTNamedTypeSpecifier)specifier);
        }
        if (specifier instanceof IASTSimpleDeclSpecifier) {
            return this._getBuiltInType((IASTSimpleDeclSpecifier)specifier);
        }
        if (specifier != null) {
            return this._getBuiltInType(specifier);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(specifier).toString());
    }

    @XbaseGenerated
    public boolean isChar(IASTDeclSpecifier specifier) {
        if (specifier instanceof IASTSimpleDeclSpecifier) {
            return this._isChar((IASTSimpleDeclSpecifier)specifier);
        }
        if (specifier != null) {
            return this._isChar(specifier);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(specifier).toString());
    }

    @XbaseGenerated
    public boolean isArray(IASTDeclarator declarator) {
        if (declarator instanceof IASTArrayDeclarator) {
            return this._isArray((IASTArrayDeclarator)declarator);
        }
        if (declarator != null) {
            return this._isArray(declarator);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(declarator).toString());
    }

    @XbaseGenerated
    public boolean isVisible(IASTNode declSpecifier) {
        if (declSpecifier instanceof IASTCompositeTypeSpecifier) {
            return this._isVisible((IASTCompositeTypeSpecifier)declSpecifier);
        }
        if (declSpecifier instanceof IASTEnumerationSpecifier) {
            return this._isVisible((IASTEnumerationSpecifier)declSpecifier);
        }
        if (declSpecifier instanceof IASTDeclaration) {
            return this._isVisible((IASTDeclaration)declSpecifier);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(declSpecifier).toString());
    }
}

