/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.domain.c.runtime.validator;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.yakindu.base.expressions.expressions.AssignmentExpression;
import com.yakindu.base.expressions.expressions.ElementReferenceExpression;
import com.yakindu.base.expressions.expressions.FeatureCall;
import com.yakindu.base.expressions.expressions.IntLiteral;
import com.yakindu.base.expressions.expressions.Literal;
import com.yakindu.base.expressions.expressions.PrimitiveValueExpression;
import com.yakindu.base.expressions.expressions.StringLiteral;
import com.yakindu.base.expressions.util.ExpressionExtensions;
import com.yakindu.base.types.AnnotatableElement;
import com.yakindu.base.types.Argument;
import com.yakindu.base.types.ComplexType;
import com.yakindu.base.types.Declaration;
import com.yakindu.base.types.Expression;
import com.yakindu.base.types.Parameter;
import com.yakindu.base.types.Property;
import com.yakindu.base.types.TypeAlias;
import com.yakindu.base.types.TypedDeclaration;
import com.yakindu.base.types.inferrer.ITypeSystemInferrer;
import com.yakindu.base.types.typesystem.ITypeSystem;
import com.yakindu.base.types.validation.IValidationIssueAcceptor;
import com.yakindu.sct.domain.c.runtime.validator.CBuiltInTypesValidator;
import com.yakindu.sct.domain.c.runtime.validator.CSTextValidationMessages;
import com.yakindu.sct.domain.c.runtime.validator.ShortIdentifiersValidator;
import com.yakindu.sct.generator.c.types.CTypeAnnotations;
import com.yakindu.sct.generator.c.typesystem.CTypeSystem;
import com.yakindu.sct.model.sgraph.util.StatechartUtil;
import com.yakindu.sct.model.stext.stext.EventDefinition;
import com.yakindu.sct.model.stext.stext.OperationDefinition;
import com.yakindu.sct.model.stext.stext.VariableDefinition;
import com.yakindu.sct.model.stext.validation.STextValidator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.ComposedChecks;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@ComposedChecks(validators={CBuiltInTypesValidator.class, ShortIdentifiersValidator.class})
public class CSTextJavaValidator
extends STextValidator
implements CSTextValidationMessages {
    @Inject
    @Extension
    private ITypeSystemInferrer _iTypeSystemInferrer;
    @Inject
    private ITypeSystem typeSystem;
    @Inject
    @Extension
    private ExpressionExtensions _expressionExtensions;
    @Inject
    @Extension
    private StatechartUtil _statechartUtil;
    @Inject
    @Extension
    protected CTypeAnnotations _cTypeAnnotations;

    @Check
    public void checkExpression_OperationDefinition(OperationDefinition it) {
        if (it.getType() == null || it.getType().eIsProxy()) {
            return;
        }
        this._iTypeSystemInferrer.infer((EObject)it, (IValidationIssueAcceptor)this);
    }

    @Check
    public void checkExpression_EventDefinition(EventDefinition it) {
        if (it.getType() == null || it.getType().eIsProxy()) {
            return;
        }
        this._iTypeSystemInferrer.infer((EObject)it, (IValidationIssueAcceptor)this);
    }

    @Check
    public void checkExpression_Parameter(Parameter it) {
        if (it.getType() == null || it.getType().eIsProxy()) {
            return;
        }
        this._iTypeSystemInferrer.infer((EObject)it, (IValidationIssueAcceptor)this);
    }

    @Check
    public void checkExpression_TypeAlias(TypeAlias it) {
        if (it.getType() == null || it.getType().eIsProxy()) {
            return;
        }
        this._iTypeSystemInferrer.infer((EObject)it, (IValidationIssueAcceptor)this);
    }

    @Check
    public void checkVariableOfTypeArray_VariableDefinition(VariableDefinition it) {
        if (it.getType() == null || it.getType().eIsProxy()) {
            return;
        }
        boolean _isSame = this.typeSystem.isSame(it.getType().getOriginType(), this.typeSystem.getType("array"));
        if (_isSame) {
            this.error(String.format("Array definition (%s) within statechart not supported yet. Use external array instead.", it.getName()), (EObject)it, null);
        }
    }

    @Check
    public void checkUniquePointerVariable(VariableDefinition it) {
        boolean _equals = it.getTypeSpecifier().getType().getName().equals("unique_ptr");
        if (_equals) {
            this.warning(String.format("Declaring variable with type \"unique_ptr\" is discouraged because the generated code won't handle it properly.", new Object[0]), (EObject)it, null);
        }
    }

    @Check
    public void checkPointerAssignmentToLocalVariable(AssignmentExpression it) {
        if (it.getVarRef() instanceof FeatureCall && it.getExpression() instanceof FeatureCall) {
            Functions.Function1 _function;
            boolean _exists;
            boolean _isMultiSM_1;
            boolean _not_1;
            boolean _not;
            Expression _varRef = it.getVarRef();
            EObject varRefFeature = ((FeatureCall)_varRef).getFeature();
            boolean _isMultiSM = this._statechartUtil.isMultiSM(varRefFeature.eContainer());
            boolean bl = _not = !_isMultiSM;
            if (_not) {
                return;
            }
            Expression _expression = it.getExpression();
            EObject _featureOrReference = this._expressionExtensions.featureOrReference(((FeatureCall)_expression).getOwner());
            EObject _eContainer = null;
            if (_featureOrReference != null) {
                _eContainer = _featureOrReference.eContainer();
            }
            boolean bl2 = _not_1 = !(_isMultiSM_1 = this._statechartUtil.isMultiSM(_eContainer));
            if (_not_1) {
                return;
            }
            Expression _expression_1 = it.getExpression();
            EObject feature = ((FeatureCall)_expression_1).getFeature();
            if (feature instanceof TypedDeclaration && (_exists = IterableExtensions.exists((Iterable)CTypeSystem.POINTER_TYPES, (Functions.Function1)(_function = t -> this.typeSystem.isSame(((TypedDeclaration)feature).getType().getOriginType(), this.typeSystem.getType(t)))))) {
                Expression _varRef_1 = it.getVarRef();
                EObject _feature = ((FeatureCall)_varRef_1).getFeature();
                this.error(String.format("Dereferencing on pointer to '%s' is not allowed. Use statechart local variable instead.", ((Declaration)_feature).getName()), (EObject)it, null);
            }
        }
    }

    @Check
    public void checkPropertyAssignmentInComplexTypeToLocalVariable(AssignmentExpression it) {
        Expression varRef = it.getVarRef();
        if (varRef instanceof FeatureCall) {
            boolean _not_1;
            boolean _not;
            EObject _feature = ((FeatureCall)varRef).getFeature();
            boolean bl = _not = !(_feature instanceof Property);
            if (_not) {
                return;
            }
            EObject _eContainer = ((FeatureCall)varRef).getFeature().eContainer();
            boolean bl2 = _not_1 = !(_eContainer instanceof ComplexType);
            if (_not_1) {
                return;
            }
            boolean _isMultiSM = this._statechartUtil.isMultiSM(((FeatureCall)varRef).getFeature().eContainer());
            if (_isMultiSM) {
                return;
            }
            Functions.Function1 _function = it_1 -> this._expressionExtensions.featureOrReference((Expression)it_1);
            TypedDeclaration typedDeclaration = (TypedDeclaration)IterableExtensions.head((Iterable)Iterables.filter((Iterable)ListExtensions.map((List)this._expressionExtensions.toCallStack(varRef), (Functions.Function1)_function), TypedDeclaration.class));
            boolean _isMultiSM_1 = this._statechartUtil.isMultiSM((EObject)typedDeclaration.getType());
            if (_isMultiSM_1) {
                EObject _feature_1 = ((FeatureCall)varRef).getFeature();
                this.error(String.format("Assignment to '%s' from submachine '%s' is not allowed. Use statechart local variable instead.", ((Declaration)_feature_1).getName(), typedDeclaration.getName()), (EObject)it, null);
            }
        }
    }

    @Check
    public void checkArrayAssignment(AssignmentExpression it) {
        Expression varRef = it.getVarRef();
        EObject ref = this._expressionExtensions.featureOrReference(varRef);
        if (ref instanceof Property) {
            Expression _expression_1;
            Literal expressionValue;
            Expression _expression;
            boolean _hasCharArrayAnnotation;
            boolean _isSame = this.typeSystem.isSame(((Property)ref).getType().getOriginType(), this.typeSystem.getType("array"));
            if (_isSame) {
                boolean _isArrayAccess_1;
                boolean _isArrayAccess;
                if (varRef instanceof ElementReferenceExpression && (_isArrayAccess = ((ElementReferenceExpression)varRef).isArrayAccess())) {
                    return;
                }
                if (varRef instanceof FeatureCall && (_isArrayAccess_1 = ((FeatureCall)varRef).isArrayAccess())) {
                    return;
                }
                this.error(String.format("Assignment to array '%s' is not allowed. Only array access is allowed: '%s[ ]'.", ((Property)ref).getName(), ((Property)ref).getName()), (EObject)it, null);
            }
            if ((_hasCharArrayAnnotation = this._cTypeAnnotations.hasCharArrayAnnotation((AnnotatableElement)ref)) && (_expression = it.getExpression()) instanceof PrimitiveValueExpression && (expressionValue = ((PrimitiveValueExpression)(_expression_1 = it.getExpression())).getValue()) instanceof StringLiteral) {
                int stringLength = ((StringLiteral)expressionValue).getValue().length();
                Expression _value = ((Argument)IterableExtensions.head((Iterable)this._cTypeAnnotations.getCharArrayAnnotation((AnnotatableElement)ref).getArguments())).getValue();
                Literal _value_1 = ((PrimitiveValueExpression)_value).getValue();
                long charArraySize = ((IntLiteral)_value_1).getValue();
                if (charArraySize != 0L && (long)stringLength >= charArraySize) {
                    this.error(String.format("The assigned string to Char array '%s' is out of bounds.", ((Property)ref).getName(), ((Property)ref).getName()), (EObject)it, null);
                }
            }
        }
    }
}

