/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.domain.c.runtime.validator;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.yakindu.base.base.BasePackage;
import com.yakindu.base.base.NamedElement;
import com.yakindu.base.types.Declaration;
import com.yakindu.sct.domain.c.runtime.validator.ShortNamesValidationMessages;
import com.yakindu.sct.domain.c.runtime.validator.StatechartIdentifiers;
import com.yakindu.sct.generator.c.concepts.CStatechartAnnotations;
import com.yakindu.sct.model.sexec.ExecutionFlow;
import com.yakindu.sct.model.sexec.transformation.IModelSequencer;
import com.yakindu.sct.model.sgraph.Scope;
import com.yakindu.sct.model.sgraph.State;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.stext.stext.InterfaceScope;
import com.yakindu.sct.model.stext.stext.InternalScope;
import com.yakindu.sct.model.stext.stext.StatechartScope;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.validation.EValidatorRegistrar;

public class ShortIdentifiersValidator
extends AbstractDeclarativeValidator
implements ShortNamesValidationMessages {
    public static final int MAX_LENGTH = 31;
    @Inject
    protected StatechartIdentifiers identifiers;
    @Inject
    protected IModelSequencer sequencer;

    @Check(value=CheckType.FAST)
    public void checkStateNameLength(State state) {
        if (!this.isValidationNeeded(this.getStatechart(state))) {
            return;
        }
        String stateName = this.stateName(state);
        if (stateName.length() > 31) {
            this.warning(String.format("State name leads to C identifier %s which is longer than 31 characters.", stateName), (EObject)state, (EStructuralFeature)BasePackage.Literals.NAMED_ELEMENT__NAME);
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkSourceCodeNames(Statechart statechart) {
        if (!this.isValidationNeeded(statechart)) {
            return;
        }
        try {
            ExecutionFlow flow = this.sequencer.transform(statechart);
            Map<NamedElement, String> names = this.identifiers.getIdentifiers(flow);
            for (NamedElement element : names.keySet()) {
                String name = names.get(element);
                if (name.length() <= 31) continue;
                this.identifierError(element, name, statechart);
            }
        }
        catch (Exception ex) {
            return;
        }
    }

    protected void identifierError(NamedElement element, String name, Statechart statechart) {
        String msg = String.format("Element name leads to C identifier %s, which is longer than 31 characters.", name);
        EObject object = this.findSGraphElement(element, statechart);
        this.warning(msg, object, (EStructuralFeature)BasePackage.Literals.NAMED_ELEMENT__NAME);
    }

    protected EObject findSGraphElement(NamedElement element, Statechart statechart) {
        if (element instanceof Declaration) {
            Scope scope = (Scope)element.eContainer();
            StatechartScope statechartScope = this.getStatechartScope(statechart, scope);
            EObject member = this.getScopeMember(statechartScope, element);
            return member;
        }
        return statechart;
    }

    protected EObject getScopeMember(StatechartScope statechartScope, NamedElement element) {
        for (EObject member : statechartScope.getMembers()) {
            if (!member.eClass().equals(element.eClass()) || !((NamedElement)member).getName().equals(element.getName())) continue;
            return member;
        }
        return null;
    }

    protected StatechartScope getStatechartScope(Statechart statechart, Scope flowScope) {
        EList scopes = statechart.getScopes();
        for (Scope scope : scopes) {
            if (!this.isCorrectScope(scope, flowScope)) continue;
            return (StatechartScope)scope;
        }
        return null;
    }

    protected boolean isCorrectScope(Scope scope, Scope flowScope) {
        if (scope instanceof InterfaceScope && flowScope instanceof InterfaceScope) {
            InterfaceScope sScope = (InterfaceScope)scope;
            InterfaceScope fScope = (InterfaceScope)flowScope;
            if (Objects.equal((Object)sScope.getName(), (Object)fScope.getName())) {
                return true;
            }
        } else if (scope instanceof InternalScope && flowScope instanceof InternalScope) {
            return true;
        }
        return false;
    }

    protected String stateName(State state) {
        return this.getStatechart(state).getName() + "_" + state.getName();
    }

    private Statechart getStatechart(State state) {
        return (Statechart)EcoreUtil2.getContainerOfType((EObject)state, Statechart.class);
    }

    protected boolean isValidationNeeded(Statechart statechart) {
        return CStatechartAnnotations.useShortIdentifiers((Statechart)statechart);
    }

    @Inject
    public void register(EValidatorRegistrar registrar) {
    }
}

