/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.application;

import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.yakindu.sct.generator.application.PathUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Path;

public class FileFinder {
    public List<String> findFilesDownwards(String absoluteBaseDir, String[] searchPaths, Set<String> extensions) {
        ArrayList files = Lists.newArrayList();
        String[] stringArray = searchPaths;
        int n = searchPaths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            files.addAll(this.findFilesDownwards(PathUtils.getAbsolutePath(absoluteBaseDir, path), extensions));
            ++n2;
        }
        return files;
    }

    protected List<String> findFilesDownwards(String file, Set<String> extensions) {
        File path = Path.fromOSString((String)file).toFile();
        if (!path.exists()) {
            throw new IllegalArgumentException(String.format("Folder %s does not exist!", path));
        }
        return this.findFilesDownwards(path, extensions);
    }

    protected List<String> findFilesDownwards(File fileOrFolder, Set<String> fileExtensions) {
        ArrayList absoluteFiles = Lists.newArrayList();
        if (!fileOrFolder.exists()) {
            return absoluteFiles;
        }
        try {
            String name = fileOrFolder.getName();
            if (this.isPlainDir(fileOrFolder) && !name.equals("bin") && !name.startsWith(".")) {
                File[] listFiles = fileOrFolder.listFiles();
                if (listFiles != null) {
                    File[] fileArray = listFiles;
                    int n = listFiles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File file = fileArray[n2];
                        absoluteFiles.addAll(this.findFilesDownwards(file, fileExtensions));
                        ++n2;
                    }
                }
            } else if (fileExtensions.contains(Files.getFileExtension((String)name))) {
                absoluteFiles.add(fileOrFolder.getAbsolutePath());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return absoluteFiles;
    }

    protected boolean isPlainDir(File file) throws IOException {
        return file.isDirectory() && !this.isSymbolicLink(file);
    }

    protected boolean isSymbolicLink(File file) throws IOException {
        File canon;
        if (file.getParent() == null) {
            canon = file;
        } else {
            File canonDir = file.getParentFile().getCanonicalFile();
            canon = new File(canonDir, file.getName());
        }
        return !canon.getCanonicalFile().equals(canon.getAbsoluteFile());
    }

    public List<String> findFilesUpwards(String absoluteBaseDir, String[] searchPaths, Set<String> extensions) {
        ArrayList files = Lists.newArrayList();
        String[] stringArray = searchPaths;
        int n = searchPaths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            files.addAll(this.findFilesUpwards(PathUtils.getAbsolutePath(absoluteBaseDir, path), extensions));
            ++n2;
        }
        return files;
    }

    protected List<String> findFilesUpwards(String absolutePath, Set<String> extensions) {
        File file = Path.fromOSString((String)absolutePath).toFile();
        if (!file.exists()) {
            throw new IllegalArgumentException(String.format("Folder %s does not exist!", file));
        }
        return this.findFilesUpwards(file, extensions);
    }

    protected List<String> findFilesUpwards(File fileOrFolder, Set<String> extensions) {
        ArrayList absoluteFiles = Lists.newArrayList();
        if (!fileOrFolder.exists()) {
            return absoluteFiles;
        }
        File parent = fileOrFolder.getParentFile();
        while (parent != null && parent.exists() && absoluteFiles.isEmpty()) {
            File[] listFiles = parent.listFiles();
            if (listFiles != null) {
                File[] fileArray = listFiles;
                int n = listFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (!file.isDirectory() && extensions.contains(Files.getFileExtension((String)file.getName()))) {
                        absoluteFiles.add(file.getAbsolutePath());
                    }
                    ++n2;
                }
            }
            parent = parent.getParentFile();
        }
        return absoluteFiles;
    }
}

